/*
 * Decompiled with CFR 0.152.
 */
package com.eview.adb;

import com.alibaba.fastjson.JSONObject;
import com.eview.tool.MainPane;
import com.eview.tool.MessageDialog;
import com.eview.tool.event.CmdReceiveListener;
import com.eview.tool.event.Condition;
import com.eview.tool.event.EventBusFactory;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.eview.util.Constants;
import com.eview.util.FileUtil;
import com.eview.util.PublicUtil;
import com.sun.jna.Platform;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.RingBufferHigh;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class UsbAdbServices {
    private static final Logger log = Logger.getLogger(UsbAdbServices.class);
    private static final int SOCKET_PORT = 5058;
    public static final String DATA_KEY = "data_adb";
    public static final String ADB_CMD_OUT = "out";
    public static final String ADB_CMD_ERROR = "error";
    private Socket adbSocket = null;
    private final RingBufferHigh ringBuffer = new RingBufferHigh();
    private ReceiveDataThread receiveDataThread;
    private static final String character = "utf-8";
    private static final String adb_path = Constants.currentPath + "/evd/";
    private CmdReceiveListener cmdReceiveListener;
    private static final UsbAdbServices instance = new UsbAdbServices();

    public static UsbAdbServices getInstance() {
        return instance;
    }

    private UsbAdbServices() {
        if (Platform.isMac()) {
            InputStream inputStream = UsbAdbServices.class.getResourceAsStream("/mac_os_x/serial/adb.key");
            FileUtil.copyFile(inputStream, System.getProperty("user.home") + "/.android/adbkey");
            UsbAdbServices.cmdexec("chmod -R 777 ./evd", null);
        }
    }

    public void sendMessage(byte[] data) {
        if (Constants.isDebug) {
            OutputLog outputLog = new OutputLog().setType("S").setData(BytesHexStrUtil.bytesToHexString((byte[])data)).setIsLine(true).setIsShowTime(Model_Debug.log_isShowTime.isSelected()).setTextArea(Model_Debug.log_outputArea);
            OutputLogQueue.getInstance().addDebugLog(outputLog);
            log.debug((Object)("[S]length:" + data.length + " data=" + BytesHexStrUtil.bytesToHexString((byte[])data)));
        }
        try {
            DataOutputStream dos = new DataOutputStream(this.adbSocket.getOutputStream());
            dos.write(data);
            dos.flush();
        }
        catch (IOException e) {
            log.error((Object)"SendMessage Exception", (Throwable)e);
            MessageDialog.show("Usb evd is not connected, please check!", 3);
        }
    }

    public static List<String> getADBList() {
        List[] adbList = new List[]{new ArrayList()};
        UsbAdbServices.cmdexec("evd devices", null, obj -> {
            adbList[0] = UsbAdbServices.getSubUtil(obj.getString(ADB_CMD_OUT), "List of devices attached(\n(.*)\t(.*)){1,}\n\n");
        });
        return adbList[0];
    }

    public static List<String> getSubUtil(String soap, String rgex) {
        ArrayList<String> adbList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(soap);
        while (m.find()) {
            String[] listArr = m.group().replace("List of devices attached\n", "").replace("\n\n", "").split("\n");
            for (int i = 0; i < listArr.length; ++i) {
                listArr[i] = listArr[i].substring(0, listArr[i].indexOf("\t"));
            }
            adbList.addAll(Arrays.asList(listArr));
        }
        if (adbList.size() == 0) {
            adbList.add("No EVD");
        }
        return adbList;
    }

    public boolean openEvd() {
        AtomicBoolean isOpenEvd = new AtomicBoolean(false);
        AtomicInteger time = new AtomicInteger(2);
        while (time.getAndDecrement() > 0) {
            UsbAdbServices.cmdexec("evd forward tcp:" + Constants.adbPort + " tcp:5058", MainPane.getADBKey(), obj -> {
                block2: {
                    try {
                        this.adbSocket = new Socket();
                        InetSocketAddress socketAddress = new InetSocketAddress("127.0.0.1", Constants.adbPort);
                        this.adbSocket.connect(socketAddress, 5000);
                        this.receiveDataThread = new ReceiveDataThread();
                        Constants.threadPool.execute(this.receiveDataThread);
                        isOpenEvd.set(true);
                        MainPane.adbList.setEnabled(false);
                        this.subscription();
                        time.set(0);
                    }
                    catch (Exception e) {
                        log.debug((Object)"evd Exception:", (Throwable)e);
                        if (time.get() != 1) break block2;
                        UsbAdbServices.cmdexec("evd kill-server", null);
                    }
                }
            });
        }
        return isOpenEvd.get();
    }

    public void closeEvd() {
        this.receiveDataThread.close();
        PublicUtil.close(this.adbSocket);
        MainPane.adbList.setEnabled(true);
        this.unSubscription();
    }

    public Map<String, Object> receiveMessage(int sequenceId, long timeOut) {
        Condition condition = new Condition().setSequenceId(sequenceId).setDateType("R");
        return this.cmdReceiveListener.getData(condition, timeOut);
    }

    private void subscription() {
        this.cmdReceiveListener = new CmdReceiveListener(DATA_KEY);
        EventBusFactory.getInstance().register((Object)this.cmdReceiveListener);
    }

    private void unSubscription() {
        EventBusFactory.getInstance().unregister((Object)this.cmdReceiveListener);
    }

    public static void cmdexec(String cmd, String adbKey) {
        UsbAdbServices.cmdexec(cmd, adbKey, null, null);
    }

    public static void cmdexec(String cmd, String adbKey, Consumer<JSONObject> consumer) {
        UsbAdbServices.cmdexec(cmd, adbKey, null, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cmdexec(String cmd, String adbKey, Consumer<Process> consumer1, Consumer<JSONObject> consumer2) {
        if (Constants.isDebug) {
            log.debug((Object)("evd cmd:" + cmd));
            System.out.println("evd cmd:" + cmd + " adbKey:" + adbKey);
        }
        Process process = null;
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            if (Platform.isWindows()) {
                cmds.add("cmd.exe");
                cmds.add("/c");
            } else if (Platform.isMac()) {
                cmds.add("bash");
                cmds.add("-c");
                if (cmd.startsWith("evd")) {
                    cmd = cmd.replaceFirst("evd", "./evd");
                }
            }
            if (adbKey != null && !adbKey.equals("No EVD")) {
                cmd = cmd.replaceFirst("evd", "evd -s " + adbKey);
            }
            cmds.add(cmd);
            ProcessBuilder pb = new ProcessBuilder(cmds);
            pb.directory(new File(adb_path));
            pb.environment().put("EVD_PARAM1", "win17848615980");
            pb.environment().put("EVD_PARAM2", "7848598061");
            process = pb.start();
            if (consumer1 != null) {
                consumer1.accept(process);
            }
            Future<String> futureOut = Constants.threadPool.submit(new ReaTask(process.getInputStream()));
            Future<String> futureError = Constants.threadPool.submit(new ReaTask(process.getErrorStream()));
            process.waitFor();
            JSONObject obj = new JSONObject();
            obj.put(ADB_CMD_OUT, (Object)futureOut.get());
            obj.put(ADB_CMD_ERROR, (Object)futureError.get());
            consumer2.accept(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            process.destroy();
        }
    }

    class ReceiveDataThread
    implements Runnable {
        private boolean isRunning = false;

        ReceiveDataThread() {
        }

        public void close() {
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isRunning = true;
            int time = 0;
            InputStream in = null;
            DataInputStream dis = null;
            try {
                while (this.isRunning) {
                    byte[] buffer;
                    in = UsbAdbServices.this.adbSocket.getInputStream();
                    dis = new DataInputStream(in);
                    int len = dis.read(buffer = new byte[1024]);
                    if (len > 0) {
                        CMD_Public.addRingBuffer(UsbAdbServices.this.ringBuffer, Arrays.copyOfRange(buffer, 0, len), UsbAdbServices.DATA_KEY);
                        time = 0;
                        continue;
                    }
                    if (len >= 0 || ++time != 10) continue;
                    this.isRunning = false;
                    MessageDialog.show("Usb evd is not connect, please check!", 3);
                }
            }
            catch (IOException ex) {
                try {
                    log.error((Object)ex.toString());
                }
                catch (Throwable throwable) {
                    PublicUtil.close(in, dis);
                    throw throwable;
                }
                PublicUtil.close(in, dis);
            }
            PublicUtil.close(in, dis);
        }
    }

    static class ReaTask
    implements Callable<String> {
        private InputStream is;

        ReaTask(InputStream is) {
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            String string;
            InputStreamReader insr = null;
            BufferedReader br = null;
            try {
                String line;
                insr = new InputStreamReader(this.is, UsbAdbServices.character);
                br = new BufferedReader(insr);
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                    if (!Model_Debug.debug_evdLog.isSelected()) continue;
                    OutputLog outputLog = new OutputLog().setType("R").setChannel("cmd_evd").setData(line + "\r\n").setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextArea(Model_Debug.debug_outputArea);
                    OutputLogQueue.getInstance().addDebugLog(outputLog);
                }
                string = sb.toString();
            }
            catch (IOException e) {
                String string2;
                try {
                    e.printStackTrace();
                    string2 = null;
                }
                catch (Throwable throwable) {
                    PublicUtil.close(this.is, br, insr);
                    throw throwable;
                }
                PublicUtil.close(this.is, br, insr);
                return string2;
            }
            PublicUtil.close(this.is, br, insr);
            return string;
        }
    }
}

