/*
 * Decompiled with CFR 0.152.
 */
package com.eview.hid;

import com.eview.tool.MessageDialog;
import com.eview.tool.event.CmdReceiveListener;
import com.eview.tool.event.Condition;
import com.eview.tool.event.EventBusFactory;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.eview.util.Constants;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.CheckCRC;
import com.tracker.util.RingBufferHigh;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;
import org.hid4java.event.HidServicesEvent;

public class UsbHidServices
implements HidServicesListener {
    private static final Logger log = Logger.getLogger(UsbHidServices.class);
    private static final Integer VENDOR_ID = 6421;
    private static final Integer PRODUCT_ID = 21004;
    private static final int PACKET_LENGTH = 64;
    private static final String SERIAL_NUMBER = null;
    public static final String DATA_KEY = "data_hid";
    private boolean isShow = true;
    private HidServices hidServices;
    private Map<HidDevice, RingBufferHigh> hidDevices = new HashMap<HidDevice, RingBufferHigh>();
    private static final UsbHidServices instance = new UsbHidServices();
    private CmdReceiveListener cmdReceiveListener;

    public static UsbHidServices getInstance() {
        return instance;
    }

    private UsbHidServices() {
        int scanInterval = Integer.parseInt(Constants.configFileUtil.readProperty("HidService", "ScanInterval", "100"));
        int pauseInterval = Integer.parseInt(Constants.configFileUtil.readProperty("HidService", "PauseInterval", "100"));
        int dataReadInterval = Integer.parseInt(Constants.configFileUtil.readProperty("HidService", "DataReadInterval", "100"));
        log.debug((Object)("scanInterval=" + scanInterval + " pauseInterval=" + pauseInterval + " dataReadInterval=" + dataReadInterval));
        HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
        hidServicesSpecification.setScanInterval(scanInterval);
        hidServicesSpecification.setPauseInterval(pauseInterval);
        hidServicesSpecification.setDataReadInterval(dataReadInterval);
        hidServicesSpecification.setAutoDataRead(true);
        hidServicesSpecification.setScanMode(ScanMode.SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE);
        this.hidServices = HidManager.getHidServices((HidServicesSpecification)hidServicesSpecification);
        this.hidServices.addHidServicesListener((HidServicesListener)this);
        this.hidServices.start();
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            if (!hidDevice.isVidPidSerial(VENDOR_ID.intValue(), PRODUCT_ID.intValue(), SERIAL_NUMBER)) continue;
            if (hidDevice.isClosed()) {
                hidDevice.open();
            }
            this.hidDevices.put(hidDevice, new RingBufferHigh());
            this.subscription(hidDevice);
        }
    }

    public void hidDeviceAttached(HidServicesEvent event) {
        log.debug((Object)("Device attached: " + String.valueOf(event)));
        if (event.getHidDevice().isVidPidSerial(VENDOR_ID.intValue(), PRODUCT_ID.intValue(), SERIAL_NUMBER)) {
            HidDevice hidDevice = event.getHidDevice();
            if (hidDevice.isClosed()) {
                hidDevice.open();
            }
            this.hidDevices.put(hidDevice, new RingBufferHigh());
            log.debug((Object)("add hid\uff1a" + event.getHidDevice().hashCode()));
            this.subscription(hidDevice);
        }
    }

    public void hidDeviceDetached(HidServicesEvent event) {
        log.debug((Object)("Device detached: " + String.valueOf(event)));
        if (event.getHidDevice().isVidPidSerial(VENDOR_ID.intValue(), PRODUCT_ID.intValue(), SERIAL_NUMBER)) {
            this.hidDevices.remove(event.getHidDevice());
            this.unSubscription(event.getHidDevice());
            event.getHidDevice().close();
        }
    }

    public void hidFailure(HidServicesEvent event) {
        log.debug((Object)("HID failure: " + String.valueOf(event)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hidDataReceived(HidServicesEvent event) {
        byte[] dataReceived = event.getDataReceived();
        if (Constants.isDebug) {
            log.debug((Object)("[R]length:" + dataReceived.length + " hid:" + BytesHexStrUtil.bytesToHexString((byte[])dataReceived)));
        }
        RingBufferHigh bufferData = this.hidDevices.get(event.getHidDevice());
        int read = 0;
        while (read < dataReceived.length) {
            byte[] readData = Arrays.copyOfRange(dataReceived, read, read + 64);
            read += 64;
            int crc = readData[1] & 0xFF | (readData[2] & 0xFF) << 8;
            byte length = readData[3];
            byte[] bodyData = Arrays.copyOfRange(readData, 4, 4 + length);
            int checkCRC = CheckCRC.crc16_bit((byte[])bodyData);
            if (crc != checkCRC || length != bodyData.length) continue;
            if (Constants.isDebug) {
                log.debug((Object)("[R]length:" + readData.length + " data:" + BytesHexStrUtil.bytesToHexString((byte[])bodyData)));
            }
            HidDevice hidDevice = event.getHidDevice();
            synchronized (hidDevice) {
                CMD_Public.addRingBuffer(bufferData, bodyData, DATA_KEY + event.getHidDevice().hashCode());
            }
        }
    }

    public Set<HidDevice> getHidDeviceList() {
        return this.hidDevices.keySet();
    }

    public void sendMessage(byte[] data) {
        if (this.hidDevices.size() > 0) {
            this.sendMessage((HidDevice)((Map.Entry)this.hidDevices.entrySet().stream().findFirst().get()).getKey(), data);
        } else {
            this.sendMessage(null, data);
        }
    }

    public void sendMessage(HidDevice hidDevice, byte[] data) {
        int size;
        if (hidDevice == null || hidDevice.isClosed()) {
            if (this.isShow) {
                this.isShow = false;
                MessageDialog.show("Hid port is not connected or occupied, please check!", 3);
                this.isShow = true;
            }
            return;
        }
        if (Constants.isDebug) {
            OutputLog outputLog = new OutputLog().setType("S").setData(BytesHexStrUtil.bytesToHexString((byte[])data)).setIsLine(true).setIsShowTime(Model_Debug.log_isShowTime.isSelected()).setTextArea(Model_Debug.log_outputArea);
            OutputLogQueue.getInstance().addDebugLog(outputLog);
            log.debug((Object)String.format("[S]length:%s data:%s", data.length, BytesHexStrUtil.bytesToHexString((byte[])data)));
        }
        for (int read = 0; read < data.length; read += size) {
            size = 59;
            if (read + size > data.length) {
                size = data.length - read;
            }
            byte[] bodyData = Arrays.copyOfRange(data, read, read + size);
            int CRC = CheckCRC.crc16_bit((byte[])bodyData);
            byte[] headData = new byte[]{1, (byte)(CRC & 0xFF), (byte)(CRC >> 8 & 0xFF), (byte)size};
            byte[] messageData = ArrayUtils.addAll((byte[])headData, (byte[])bodyData);
            int val = hidDevice.write(messageData, 64, (byte)0);
            if (!Constants.isDebug) continue;
            log.debug((Object)("[S]length:" + val + " hid:" + BytesHexStrUtil.bytesToHexString((byte[])messageData)));
        }
    }

    public Map<String, Object> receiveMessage(int sequenceId, long timeOut) {
        HidDevice hidDevice = this.hidDevices.entrySet().stream().findFirst().map(m -> (HidDevice)m.getKey()).orElse(null);
        return this.receiveMessage(hidDevice, sequenceId, timeOut);
    }

    public Map<String, Object> receiveMessage(HidDevice hidDevice, int sequenceId, long timeOut) {
        if (hidDevice == null) {
            return null;
        }
        Condition condition = new Condition().setSequenceId(sequenceId).setDateType("R");
        return this.cmdReceiveListener.getData(condition, timeOut);
    }

    private void subscription(HidDevice hidDevice) {
        log.debug((Object)("subscription hidDevice=" + hidDevice.hashCode()));
        this.cmdReceiveListener = new CmdReceiveListener(DATA_KEY + hidDevice.hashCode());
        EventBusFactory.getInstance().register((Object)this.cmdReceiveListener);
    }

    private void unSubscription(HidDevice hidDevice) {
        log.debug((Object)("unSubscription hidDevice=" + hidDevice.hashCode()));
        EventBusFactory.getInstance().unregister((Object)this.cmdReceiveListener);
    }

    public void setConfigFile() {
        Constants.configFileUtil.setProperty("HidService", "ScanInterval", "100");
        Constants.configFileUtil.setProperty("HidService", "PauseInterval", "100");
        Constants.configFileUtil.setProperty("HidService", "DataReadInterval", "100");
        Constants.configFileUtil.writeProperty();
    }
}

