/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import com.eview.util.Constants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class WelcomeWindow
extends JWindow {
    private static final long serialVersionUID = 1L;
    private CountDownLatch begin = new CountDownLatch(1);

    public WelcomeWindow() {
        ImageIcon welcomeImage = new ImageIcon(Constants.welcomeImagePath);
        JLabel label = new JLabel(welcomeImage);
        this.getContentPane().add((Component)label, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = label.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.setVisible(true);
        Runnable closerRunner = () -> {
            this.setVisible(false);
            this.dispose();
        };
        Runnable waitRunner = () -> {
            try {
                this.begin.await();
                SwingUtilities.invokeAndWait(closerRunner);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        Constants.threadPool.execute(new Thread(waitRunner, "SplashThread"));
    }

    public void close() {
        this.begin.countDown();
    }
}

