/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.customUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.ComboPopup;

public class TimePicker
extends JPanel {
    private JComponent showDate;
    private JPanel calendarPanel;
    private boolean isShow = false;
    private static Color hoverColor = Color.BLUE;
    private Popup pop;
    private BodyPanel bodyPanel;
    private static final int DEFAULT_WIDTH = 218;

    private TimePicker(Date date) {
        this.initCalendarPanel();
    }

    public static TimePicker getInstance() {
        return new TimePicker(new Date());
    }

    private void initCalendarPanel() {
        this.calendarPanel = new JPanel(new BorderLayout());
        this.calendarPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170)));
        this.bodyPanel = new BodyPanel();
        this.calendarPanel.add((Component)this.bodyPanel, "Center");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                TimePicker.this.hidePanel();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                TimePicker.this.hidePanel();
            }
        });
    }

    public void register(final JComponent showComponent) {
        this.showDate = showComponent;
        showComponent.setRequestFocusEnabled(true);
        showComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                showComponent.requestFocusInWindow();
            }
        });
        this.add((Component)showComponent, "Center");
        this.setPreferredSize(new Dimension(90, 25));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        showComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setCursor(new Cursor(0));
                    showComponent.setForeground(Color.BLACK);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setForeground(hoverColor);
                    if (TimePicker.this.isShow) {
                        TimePicker.this.hidePanel();
                    } else {
                        TimePicker.this.showPanel(showComponent);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setForeground(Color.BLACK);
                }
            }
        });
        showComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TimePicker.this.hidePanel();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void hidePanel() {
        if (this.pop != null) {
            this.isShow = false;
            this.pop.hide();
            this.pop = null;
        }
    }

    private void showPanel(Component owner) {
        if (this.pop != null) {
            this.pop.hide();
        }
        Point show = new Point(0, this.showDate.getHeight());
        SwingUtilities.convertPointToScreen(show, this.showDate);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = show.x;
        int y = show.y;
        if (x < 0) {
            x = 0;
        }
        if (x > size.width - 212) {
            x = size.width - 212;
        }
        if (y > size.height - 167) {
            y -= 165;
        }
        this.pop = PopupFactory.getSharedInstance().getPopup(owner, this.calendarPanel, x, y);
        this.pop.show();
        this.isShow = true;
    }

    private void commit() {
        if (this.showDate instanceof JTextField) {
            ((JTextField)this.showDate).setText("11");
        } else if (this.showDate instanceof JLabel) {
            ((JLabel)this.showDate).setText("22");
        }
        this.hidePanel();
    }

    private class BodyPanel
    extends JPanel {
        private static final long serialVersionUID = 5677718768457235447L;

        public BodyPanel() {
            super(new GridLayout(7, 7));
            this.setPreferredSize(new Dimension(218, 140));
            this.initMonthPanel();
        }

        private void initMonthPanel() {
            this.updateDate();
        }

        public void updateDate() {
            this.removeAll();
            this.add(new MyComboBox());
        }
    }

    private class MyComboBox<T>
    extends JComboBox {
        public MyComboBox() {
            this.setUI(new BasicComboBoxUI(){

                @Override
                protected JButton createArrowButton() {
                    return new JButton(){

                        @Override
                        public int getWidth() {
                            return 0;
                        }

                        @Override
                        public void setFocusable(boolean focusable) {
                            super.setFocusable(false);
                        }
                    };
                }

                @Override
                protected ComboPopup createPopup() {
                    return new BasicComboPopup(this.comboBox){

                        @Override
                        protected JScrollPane createScroller() {
                            JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                            scroller.getVerticalScrollBar().setUI(new BasicScrollBarUI(){

                                @Override
                                protected JButton createDecreaseButton(int orientation) {
                                    return this.createZeroButton();
                                }

                                @Override
                                protected JButton createIncreaseButton(int orientation) {
                                    return this.createZeroButton();
                                }

                                @Override
                                public Dimension getPreferredSize(JComponent c) {
                                    return new Dimension(0, super.getPreferredSize((JComponent)c).height);
                                }

                                private JButton createZeroButton() {
                                    return new JButton(){

                                        @Override
                                        public Dimension getMinimumSize() {
                                            return new Dimension(new Dimension(0, 0));
                                        }

                                        @Override
                                        public Dimension getPreferredSize() {
                                            return new Dimension(new Dimension(0, 0));
                                        }

                                        @Override
                                        public Dimension getMaximumSize() {
                                            return new Dimension(new Dimension(0, 0));
                                        }
                                    };
                                }
                            });
                            return scroller;
                        }
                    };
                }
            });
        }
    }
}

