/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.html;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.MainPane;
import com.eview.tool.html.JsCallback;
import com.eview.tool.model.PanelUtil;
import com.eview.util.FileUtil;
import com.eview.util.PublicUtil;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextField;
import net.coobird.thumbnailator.Thumbnails;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ContactAvatar {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 380;
    private static JSONObject panePhone;
    private static String photoKey;
    private static String directory;
    private Display display;
    private Shell shell;
    private static ContactAvatar instance;

    public static ContactAvatar getInstance() {
        return instance;
    }

    private ContactAvatar() {
    }

    public void show(JSONObject panePhone, String photoKey) {
        Browser browser;
        ContactAvatar.panePhone = panePhone;
        ContactAvatar.photoKey = photoKey;
        directory = photoKey.contains("personalInfo") ? "head2" : "head";
        this.display = new Display();
        this.shell = new Shell(this.display, 51296);
        this.shell.setText("Edit photo");
        this.shell.setSize(800, 380);
        this.shell.setLayout((Layout)new FillLayout());
        PanelUtil.setCenter(this.shell);
        try {
            browser = new Browser((Composite)this.shell, 0);
        }
        catch (SWTError e) {
            System.out.println("Could not instantiate Browser: " + e.getMessage());
            this.display.dispose();
            return;
        }
        browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            if (MainPane.getThisModel().getKey().equals("EV05")) {
                JTextField input_photo = (JTextField)panePhone.get((Object)(photoKey + "_headURL"));
                File photoFile = new File(input_photo.getName());
                String photoPath = photoFile.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
                browser.execute("setPhotoPath('" + photoPath + "')");
            }
            new JsCallback(browser, "saveImage", arguments -> {
                String iconName = Convert.toStr((Object)arguments[0]);
                if (MainPane.getThisModel().getKey().equals("EV05")) {
                    this.setPhoto_05(iconName);
                } else if (MainPane.getThisModel().getKey().equals("EV06")) {
                    this.setPhoto_06(iconName);
                }
                return null;
            });
            new JsCallback(browser, "changeImage", arguments -> {
                FileDialog dialog = new FileDialog(this.shell, 4096);
                dialog.setText("Select File");
                dialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.*"});
                String filePath = dialog.open();
                if (dialog != null) {
                    return filePath;
                }
                return null;
            });
        }));
        String htmlPath = "";
        if (MainPane.getThisModel().getKey().equals("EV05")) {
            htmlPath = FileUtil.getCurrentPath("./html/cropper/photo_05.html");
        } else if (MainPane.getThisModel().getKey().equals("EV06")) {
            htmlPath = FileUtil.getCurrentPath("./html/cropper/photo_06.html");
        }
        browser.setUrl("file:///" + htmlPath);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public void setPhoto_05(String data) {
        if (data.isEmpty()) {
            JButton button_avatar = (JButton)panePhone.get((Object)(photoKey + "_avatar"));
            String defaultIcon = FileUtil.getCurrentPath("./html/cropper/images/avatar.png");
            PublicUtil.resetImage(button_avatar, defaultIcon);
            JTextField input_headURL = (JTextField)panePhone.get((Object)(photoKey + "_headURL"));
            input_headURL.setName(defaultIcon);
            input_headURL.setText("");
            this.display.dispose();
            return;
        }
        JSONObject photo_data = JSON.parseObject((String)data);
        int x = (int)photo_data.getDoubleValue("x");
        int y = (int)photo_data.getDoubleValue("y");
        int width = (int)photo_data.getDoubleValue("width");
        int height = (int)photo_data.getDoubleValue("height");
        String photoPath = photo_data.getString("src");
        File original = new File(photoPath);
        String target = FileUtil.getCurrentPath("./temp/" + directory + "/" + photoKey + ".png");
        File targetFile = new File(target);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            Thumbnails.of((File[])new File[]{original}).sourceRegion(x, y, width, height).size(454, 454).keepAspectRatio(false).toFile(targetFile);
            JTextField input_photo = (JTextField)panePhone.get((Object)(photoKey + "_headURL"));
            input_photo.setText("sdcard/" + directory + "/" + photoKey + ".png");
            JButton button_avatar = (JButton)panePhone.get((Object)(photoKey + "_avatar"));
            PublicUtil.resetImage(button_avatar, target);
            this.display.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPhoto_06(String iconName) {
        JTextField input_photo = (JTextField)panePhone.get((Object)(photoKey + "_headURL"));
        input_photo.setText("T" + iconName.replace(".png", ""));
        String photoPath = FileUtil.getCurrentPath("./html/cropper/images/" + iconName);
        JButton button_avatar = (JButton)panePhone.get((Object)(photoKey + "_avatar"));
        int iconWidth = button_avatar.getIcon().getIconWidth();
        int iconHeight = button_avatar.getIcon().getIconHeight();
        ImageIcon avatar = MainPane.resourceManager.getImageIcon(photoPath);
        Image image = avatar.getImage();
        image = image.getScaledInstance(iconWidth, iconHeight, 1);
        avatar.setImage(image);
        button_avatar.setIcon(avatar);
        button_avatar.setPressedIcon(avatar);
        this.display.dispose();
    }

    static {
        directory = "";
        instance = new ContactAvatar();
    }
}

