/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import com.eview.tool.MainPane;
import com.eview.tool.event.CmdData;
import com.eview.tool.event.EventBusFactory;
import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.util.ArrayUtils;
import com.tracker.util.RingBufferHigh;
import java.util.HashMap;
import java.util.Map;

public class CMD_Public {
    public static void addRingBuffer(RingBufferHigh ringBuffer, byte[] data, String key) {
        MainPane.protocol.addBuffer(ringBuffer, data, cmdObj -> {
            CmdModel cmdModel = (CmdModel)cmdObj;
            Map objectData = MainPane.protocol.protocolAnalysis(cmdModel);
            if (objectData != null) {
                CmdData cmdData = new CmdData().setChannel(key).setDateType("R").setSequenceId(cmdModel.getHeadData().getSequenceId()).setData(objectData);
                EventBusFactory.getInstance().post((Object)cmdData);
            }
        });
    }

    public static byte[] getPasswordVerify(int sequenceId, String password) {
        byte[] passwordByte = ProtocolUtil.long2Bytes((long)new Long(password), (int)4);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommandBody(9, 13, passwordByte);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }

    public static byte[] shutdown(int sequenceId) {
        byte[] bodyData = new byte[]{4, 1, 20};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] reboot(int sequenceId) {
        byte[] bodyData = new byte[]{4, 1, 18};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] refactory(int sequenceId) {
        byte[] bodyData = new byte[]{4, 1, 17};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendMusicTest(int sequenceId) {
        byte[] bodyData = new byte[]{-2, 6, 23, 1, 0, 0, 0, 0};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendNone(int sequenceId) {
        byte[] bodyData = new byte[]{6, 5, 80, 0, 0, 0, 0};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendGPS(int sequenceId) {
        byte[] bodyData = new byte[]{6, 5, 80, 1, 0, 0, 0};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendGSM(int sequenceId) {
        byte[] bodyData = new byte[]{6, 5, 80, 2, 0, 0, 0};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendAT(int sequenceId, byte[] cmd) {
        byte[] bodyData = new byte[]{6, 0, 84};
        if (cmd != null) {
            bodyData = ArrayUtils.addAll((byte[])bodyData, (byte[])cmd);
        }
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendSMS(int sequenceId, byte[] cmd) {
        byte[] bodyData = new byte[]{6, 0, 38};
        if (cmd != null) {
            bodyData = ArrayUtils.addAll((byte[])bodyData, (byte[])cmd);
        }
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] onlyAT(int sequenceId) {
        byte[] bodyData = new byte[]{6, 1, 52};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] heatBeat(int sequenceId) {
        byte[] bodyData = new byte[]{3, 1, 49};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] divStatus(int sequenceId) {
        byte[] bodyData = new byte[]{6, 1, 48};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] dsStatus(int sequenceId) {
        byte[] bodyData = new byte[]{6, 1, 64};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] format(int sequenceId) {
        byte[] bodyData = new byte[]{6, 1, 123};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] setLog(int sequenceId, long value) {
        byte[] bodyData = new byte[]{6, 5, 86};
        byte[] valueBytes = ProtocolUtil.long2Bytes((long)value, (int)4);
        bodyData = ArrayUtils.addAll((byte[])bodyData, (byte[])valueBytes);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] scanBeacon(String lat, String lng, String describe) {
        HashMap param = new HashMap(1);
        HashMap<String, String> scanBeacon = new HashMap<String, String>(3);
        scanBeacon.put("lat", lat);
        scanBeacon.put("lng", lng);
        scanBeacon.put("describe", describe);
        param.put("scanBeacon", scanBeacon);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_system(param);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }

    public static byte[] scanWifiAuto(String lat, String lng, String describe) {
        HashMap param = new HashMap(1);
        HashMap<String, String> scanWifiAuto = new HashMap<String, String>(3);
        scanWifiAuto.put("lat", lat);
        scanWifiAuto.put("lng", lng);
        scanWifiAuto.put("describe", describe);
        param.put("scanWifiAuto", scanWifiAuto);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_system(param);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }
}

