/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.BottomStatusPanel;
import com.eview.tool.CheckDocument;
import com.eview.tool.MainPane;
import com.eview.tool.MessageDialog;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.event.CmdData;
import com.eview.tool.handler.HandlerChain;
import com.eview.tool.handler.HandlerListMap;
import com.eview.tool.model.Model;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class Model_DS3
extends Model
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JSONObject paneObjectAll = new JSONObject();
    private final JSONObject paneInformation = new JSONObject();
    private final JSONObject paneChargingBase = new JSONObject();
    private int spa = 12;
    private int height = 35;
    private int row_h = 47;
    private final int lab_w = 110;
    private final int lab_w2 = 150;
    private final int input_w = 218;
    private final int toggleBtn_w = 82;
    private int lab_input_w = this.spa + 110 + 218 + 40;
    private int button_w = 85;
    private boolean isGlobalCheckError;
    private JTabbedPane tabbedPane;

    public Model_DS3(String key, String name, boolean isShow) {
        this.key = key;
        this.name = name;
        this.isShow = isShow;
        this.init();
    }

    private void init() {
        this.isGlobalCheckError = Boolean.parseBoolean(Constants.configFileUtil.readProperty(this.getKey(), "checkError", "false"));
        this.setBackground(Constants.background);
        this.tabbedPane = PanelUtil.createTabbedPane(this.getLayout());
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.tabbedPane, "West");
        JPanel panel_information = new JPanel();
        panel_information.setLayout(null);
        this.tabbedPane.add("System Info", panel_information);
        this.initPanel_SystemInfo(panel_information, this.paneChargingBase);
    }

    private void initPanel_SystemInfo(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        String[][] lab_Information = new String[][]{{"Model", "Delivery date", "BLE MAC", "Date Time", "Start Time", "Run Time", "FW Version"}, {"Firmware Size", "Hardware Version"}};
        for (int i = 0; i < lab_Information.length; ++i) {
            for (int j = 0; j < lab_Information[i].length; ++j) {
                JLabel lab = new JLabel(lab_Information[i][j]);
                if (i == 0) {
                    lab.setBounds(new Rectangle(this.spa, this.spa + this.row_h * j, 110, this.height));
                } else {
                    lab.setBounds(new Rectangle(this.lab_input_w, this.spa + this.row_h * j, 150, this.height));
                }
                panel.add(lab);
            }
        }
        String[][] input_Information = new String[][]{{"deviceName", "module", "MAC", "dateTime", "startTime", "runTime", "version"}, {"firmware_firmwareSize", "firmware_hardwareVersion"}};
        for (int i = 0; i < input_Information.length; ++i) {
            for (int j = 0; j < input_Information[i].length; ++j) {
                JTextField input;
                if (i == 0) {
                    input = new JTextField();
                    input.setBounds(new Rectangle(this.spa + 110, this.spa + this.row_h * j, 218, this.height));
                    input.setEditable(false);
                    panel.add(input);
                    this.paneInformation.put(input_Information[i][j], (Object)input);
                    continue;
                }
                input = new JTextField();
                input.setBounds(new Rectangle(150 + this.lab_input_w, this.spa + this.row_h * j, 218, this.height));
                input.setEditable(false);
                panel.add(input);
                this.paneInformation.put(input_Information[i][j], (Object)input);
            }
        }
        JPanel bleAddressPanel = PanelUtil.createPanel("Bluetooth Address", this.lab_input_w, (this.spa + this.row_h) * 3, 360, this.spa * 2 + this.row_h);
        panel.add(bleAddressPanel);
        JLabel lab = new JLabel("Home Coordinates");
        lab.setBounds(new Rectangle(this.spa, this.spa * 2, 125, this.height));
        bleAddressPanel.add(lab);
        PlaceholderTextField input1 = new PlaceholderTextField();
        input1.setPlaceholder("Latitude");
        input1.setBounds(new Rectangle(this.spa + 110 + 15, this.spa * 2, 100, this.height));
        PanelUtil.checkInput(input1, CheckDocument.regex_lat, checkArray);
        bleAddressPanel.add(input1);
        jsonObj.put("bleLoc_lat", (Object)input1);
        PlaceholderTextField input2 = new PlaceholderTextField();
        input2.setPlaceholder("Longitude");
        input2.setBounds(new Rectangle(this.spa + 110 + 100 + 25, this.spa * 2, 100, this.height));
        PanelUtil.checkInput(input2, CheckDocument.regex_lng, checkArray);
        bleAddressPanel.add(input2);
        jsonObj.put("bleLoc_lng", (Object)input2);
        JLabel lab_led = new JLabel("LED");
        lab_led.setBounds(new Rectangle(this.lab_input_w, (this.spa + this.row_h) * 5, 176, this.height));
        panel.add(lab_led);
        JToggleButton toggleBtn_led = new JToggleButton();
        toggleBtn_led.setIcon(MainPane.toggle_off);
        toggleBtn_led.setSelectedIcon(MainPane.toggle_on);
        toggleBtn_led.setBounds(new Rectangle(this.spa + 650, (this.spa + this.row_h) * 5, 82, this.height));
        panel.add(toggleBtn_led);
        jsonObj.put("enableControl_led", (Object)toggleBtn_led);
        JButton save_chargingBase = new JButton("Save");
        save_chargingBase.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_chargingBase);
        save_chargingBase.addActionListener(this);
        this.paneObjectAll.put("save_chargingBase", (Object)save_chargingBase);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.paneObjectAll.get((Object)"save_system_info"))) {
            this.savePanel(PanelUtil.getPanel(this.paneInformation));
        } else if (e.getSource().equals(this.paneObjectAll.get((Object)"save_chargingBase"))) {
            if (this.isGlobalCheckError && PanelUtil.checkError(this.paneObjectAll, this.paneChargingBase)) {
                return;
            }
            this.savePanel(PanelUtil.getPanel(this.paneChargingBase));
        }
    }

    public void saveAll() {
        JSONObject dataAll = PanelUtil.getPanel(this.paneInformation);
        dataAll.putAll((Map)PanelUtil.getPanel(this.paneChargingBase));
        if (this.isGlobalCheckError && PanelUtil.checkError(this.paneObjectAll, this.paneInformation, this.paneChargingBase)) {
            return;
        }
        this.savePanel(dataAll);
    }

    public void savePanel(JSONObject configData) {
        HandlerChain.Builder(configData).addHandler(new HandlerListMap()).handleResponse();
        PublicUtil.savePanel(configData);
    }

    public void clearAll() {
        PublicUtil.clearPanel((Map<String, Object>)this.paneInformation);
        PublicUtil.clearPanel((Map<String, Object>)this.paneChargingBase);
        BottomStatusPanel.setBattery(-1);
    }

    @Override
    public void listenReceiveData(CmdData cmdData) {
        MainPane.getDebugModel().listenReceiveData(cmdData);
        if ("R".equals(cmdData.getDateType())) {
            JSONObject responseData;
            JSONObject data_json = new JSONObject((Map)cmdData.getData());
            JSONObject dataClone = JSONObject.parseObject((String)data_json.toJSONString());
            JSONObject cmdBodyData = dataClone.getJSONObject("cmdBodyData");
            JSONObject configData = cmdBodyData.getJSONObject("configData");
            if (configData != null) {
                HandlerChain.Builder(configData).addHandler(new HandlerListMap()).handleRequest();
                PanelUtil.showPaneData(this.paneInformation, configData);
                PanelUtil.showPaneData(this.paneChargingBase, configData);
                BottomStatusPanel.setBattery(configData.getIntValue("battery_battery"));
                MessageDialog.show(MainPane.getThisModel(), "Read successfully.", 1000L);
            }
            if ((responseData = cmdBodyData.getJSONObject("responseData")) != null) {
                Object returnMsg = responseData.getString("returnStatus");
                if (((String)returnMsg).equals("ok")) {
                    returnMsg = "OK";
                } else if (((String)returnMsg).equals("error")) {
                    returnMsg = "ERROR:" + responseData.getString("msg");
                    if (responseData.getIntValue("code") == 22) {
                        returnMsg = "OK";
                    }
                }
                MessageDialog.show(MainPane.getThisModel(), (String)returnMsg, 2000L);
            }
        }
    }

    @Override
    public void readProfile() {
        JSONObject configData = PublicUtil.readProfile();
        HandlerChain.Builder(configData).addHandler(new HandlerListMap()).handleRequest();
        PanelUtil.showPaneData(this.paneInformation, configData);
        PanelUtil.showPaneData(this.paneChargingBase, configData);
    }

    @Override
    public void writeProfile() {
        JSONObject configData = PanelUtil.getPanel(this.paneInformation);
        configData.putAll((Map)PanelUtil.getPanel(this.paneChargingBase));
        HandlerChain.Builder(configData).addHandler(new HandlerListMap()).handleResponse();
        PublicUtil.writeProfile(configData);
    }

    @Override
    public void setConfigFile() {
        Constants.configFileUtil.setProperty(this.getKey(), "checkError", "false");
    }
}

