/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.BottomStatusPanel;
import com.eview.tool.CheckDocument;
import com.eview.tool.DocumentObject;
import com.eview.tool.DoubleValue;
import com.eview.tool.MainPane;
import com.eview.tool.MessageDialog;
import com.eview.tool.bluetooth.ScanWiFiJDialog;
import com.eview.tool.customUI.MultiComboBox;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.event.CmdData;
import com.eview.tool.handler.HandlerChain;
import com.eview.tool.handler.HandlerListMap;
import com.eview.tool.handler.HandlerNoMotionTime;
import com.eview.tool.handler.HandlerRemoveField;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class Model_EV206M
extends Model
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Logger log = Logger.getLogger(this.getClass());
    private final JSONObject paneObjectAll = new JSONObject();
    private final JSONObject paneInformation = new JSONObject();
    private final JSONObject paneContactList = new JSONObject();
    private final JSONObject paneSystems = new JSONObject();
    private final JSONObject paneButtons = new JSONObject();
    private final JSONObject paneFunction = new JSONObject();
    private final JSONObject paneAlert = new JSONObject();
    private final JSONObject paneBeacon = new JSONObject();
    private final JSONObject paneWifiList = new JSONObject();
    private Map<String, JSONObject> panels = new HashMap<String, JSONObject>(8);
    private final int spa = 12;
    private final int height = 35;
    private final int row_h = 47;
    private final int lab_w = 110;
    private final int lab_w2 = 150;
    private final int input_w = 218;
    private final int toggleBtn_w = 82;
    private final int lab_input_w = 380;
    private final int button_w = 85;
    private final int chbox_w = 80;
    private boolean isShow_Model;
    private boolean isGlobalCheckError;
    private JTabbedPane tabbedPane;

    public Model_EV206M(String key, String name, boolean isShow) {
        this.key = key;
        this.name = name;
        this.isShow = isShow;
        this.panels.put("save_system_info", this.paneInformation);
        this.panels.put("save_contactList", this.paneContactList);
        this.panels.put("save_tracking", this.paneSystems);
        this.panels.put("save_buttons", this.paneButtons);
        this.panels.put("save_function", this.paneFunction);
        this.panels.put("save_alert_settings", this.paneAlert);
        this.panels.put("save_home_beacon", this.paneBeacon);
        this.panels.put("save_home_wifi", this.paneWifiList);
        this.init();
    }

    private void init() {
        this.isShow_Model = MainPane.isShowProperty(this.getKey(), "isShow_Model", "true");
        this.isGlobalCheckError = MainPane.isShowProperty(this.getKey(), "checkError", "false");
        this.setBackground(Constants.background);
        this.tabbedPane = PanelUtil.createTabbedPane(this.getLayout());
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.tabbedPane, "West");
        JPanel panel_information = new JPanel();
        panel_information.setLayout(null);
        this.tabbedPane.add("System Info", panel_information);
        JPanel panel_phone = new JPanel();
        panel_phone.setLayout(null);
        this.tabbedPane.add("Contact Number", panel_phone);
        JPanel panel_systems = new JPanel();
        panel_systems.setLayout(null);
        this.tabbedPane.add("Tracking Settings", panel_systems);
        JPanel panel_function = new JPanel();
        panel_function.setLayout(null);
        this.tabbedPane.add("Function Settings", panel_function);
        JPanel panel_alert = new JPanel();
        panel_alert.setLayout(null);
        this.tabbedPane.add("Alert Settings", panel_alert);
        JPanel panel_beacon = new JPanel();
        panel_beacon.setLayout(null);
        this.tabbedPane.add("Home Beacon", panel_beacon);
        JPanel panel_wifiList = new JPanel();
        panel_wifiList.setLayout(null);
        this.tabbedPane.add("Home WiFi", panel_wifiList);
        this.initPanel_SystemInfo(panel_information, this.paneInformation);
        this.initPanel_ContactSetting(panel_phone, this.paneContactList);
        this.initPanel_TrackingSettings(panel_systems, this.paneSystems);
        this.initPanel_FunctionSettings(panel_function, this.paneFunction);
        this.initPanel_AlertSettings(panel_alert, this.paneAlert);
        this.initPanel_BeaconSetting(panel_beacon, this.paneBeacon);
        this.initPanel_HomeWiFi(panel_wifiList, this.paneWifiList);
    }

    private void initPanel_SystemInfo(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        String[][] lab_Information = new String[][]{{"Model", "Delivery date", "IMEI", "ICCID", "BLE MAC", "Date Time", "Start Time", "Run Time", "Version", "FW Version", "GSM Module"}, {"Firmware Size", "Hardware Version", "<html><body><p align=\"left\">Password<br/>(For SMS Command)</p></body></html>", "Time Zone"}};
        for (int i = 0; i < lab_Information.length; ++i) {
            for (int j = 0; j < lab_Information[i].length; ++j) {
                JLabel lab = new JLabel(lab_Information[i][j]);
                if (i == 0) {
                    lab.setBounds(new Rectangle(12, 12 + 47 * j, 110, 35));
                } else {
                    lab.setBounds(new Rectangle(380, 12 + 47 * j, 150, 35));
                }
                panel.add(lab);
            }
        }
        String[][] input_Information = new String[][]{{"deviceName", "module", "IMEI", "ICCID", "MAC", "dateTime", "startTime", "runTime", "version", "fwVersion", "gsmModule"}, {"firmware_firmwareSize", "firmware_hardwareVersion", "password", "timeZone"}};
        for (int i = 0; i < input_Information.length; ++i) {
            for (int j = 0; j < input_Information[i].length; ++j) {
                JTextField input;
                if (i == 0) {
                    input = new JTextField();
                    input.setBounds(new Rectangle(122, 12 + 47 * j, 218, 35));
                    input.setEditable(false);
                    panel.add(input);
                    jsonObj.put(input_Information[i][j], (Object)input);
                    continue;
                }
                if (i == 1 && j == 2) {
                    JToggleButton toggleBtn = new JToggleButton();
                    toggleBtn.setIcon(MainPane.toggle_off);
                    toggleBtn.setSelectedIcon(MainPane.toggle_on);
                    toggleBtn.setBounds(new Rectangle(530, 12 + 47 * j, 82, 35));
                    panel.add(toggleBtn);
                    jsonObj.put(input_Information[i][j] + "_status", (Object)toggleBtn);
                    PlaceholderTextField input2 = new PlaceholderTextField();
                    input2.setPlaceholder("0~999999");
                    input2.setBounds(new Rectangle(620, 12 + 47 * j, 128, 35));
                    PanelUtil.checkInput(input2, "^\\d{0,6}$", checkArray);
                    panel.add(input2);
                    jsonObj.put(input_Information[i][j] + "_password", (Object)input2);
                    continue;
                }
                if (i == 1 && j == 3) {
                    JComboBox<String> cbt_timeZone = new JComboBox<String>(Constants.timeZoneArr);
                    cbt_timeZone.setBounds(new Rectangle(530, 12 + 47 * j, 218, 35));
                    panel.add(cbt_timeZone);
                    jsonObj.put(input_Information[i][j], cbt_timeZone);
                    continue;
                }
                input = new JTextField();
                input.setBounds(new Rectangle(530, 12 + 47 * j, 218, 35));
                input.setEditable(false);
                panel.add(input);
                jsonObj.put(input_Information[i][j], (Object)input);
            }
        }
        JLabel lab_smsPrefix = new JLabel("SMS Prefix");
        lab_smsPrefix.setBounds(new Rectangle(380, 294, 150, 35));
        panel.add(lab_smsPrefix);
        JToggleButton tButtonStatus = new JToggleButton();
        tButtonStatus.setIcon(MainPane.toggle_off);
        tButtonStatus.setSelectedIcon(MainPane.toggle_on);
        tButtonStatus.setBounds(new Rectangle(530, 294, 82, 35));
        panel.add(tButtonStatus);
        jsonObj.put("smsOption_status", (Object)tButtonStatus);
        PlaceholderTextField input_smsPrefix = new PlaceholderTextField();
        input_smsPrefix.setPlaceholder("0~20 bytes");
        input_smsPrefix.setBounds(new Rectangle(622, 294, 128, 35));
        PanelUtil.checkInput(input_smsPrefix, "^[\\w\\W]{0,20}$", checkArray);
        panel.add(input_smsPrefix);
        jsonObj.put("smsOption_prefix", (Object)input_smsPrefix);
        JButton save_information = new JButton("Save");
        save_information.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_information);
        save_information.addActionListener(this);
        this.paneObjectAll.put("save_system_info", (Object)save_information);
    }

    private void initPanel_ContactSetting(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        JPanel contactPanel = PanelUtil.createPanel(700, 660);
        JScrollPane contactScrollPanel = PanelUtil.createScrollPanel(contactPanel, 5, 5, 760, 510);
        panel.add(contactScrollPanel);
        JLabel lab_number = new JLabel("When there is an alarm");
        lab_number.setBounds(new Rectangle(325, 7, 180, 35));
        contactPanel.add(lab_number);
        JSeparator sep = new JSeparator(0);
        sep.setBounds(new Rectangle(325, 40, 360, 35));
        contactPanel.add(sep);
        for (int i = 0; i < 10; ++i) {
            JLabel lab = new JLabel("A" + (i + 1));
            lab.setBounds(new Rectangle(12, 47 + 47 * i, 60, 35));
            contactPanel.add(lab);
            String numberKey = "number$" + i;
            PlaceholderTextField input = new PlaceholderTextField();
            input.setPlaceholder("Phone number");
            input.setBounds(new Rectangle(72, 47 + 47 * i, 218, 35));
            contactPanel.add(input);
            jsonObj.put(numberKey + "_number", (Object)input);
            JCheckBox cbox_SMS = new JCheckBox("Receive SMS");
            cbox_SMS.setBounds(new Rectangle(320, 47 + 47 * i, 120, 35));
            contactPanel.add(cbox_SMS);
            jsonObj.put(numberKey + "_sms", (Object)cbox_SMS);
            PanelUtil.checkInput(input, CheckDocument.regex_phone, cbox_SMS, checkArray);
            JToggleButton toggleBtn = new JToggleButton();
            toggleBtn.setIcon(MainPane.toggle_off);
            toggleBtn.setSelectedIcon(MainPane.toggle_on);
            toggleBtn.setBounds(new Rectangle(602, 47 + 47 * i, 82, 35));
            contactPanel.add(toggleBtn);
            jsonObj.put(numberKey + "_enable", (Object)toggleBtn);
        }
        JPanel contactInfoPanel = PanelUtil.createPanel("", 12, 517, 680, 124);
        contactPanel.add(contactInfoPanel);
        JLabel lab_contactInfo = new JLabel(Constants.contact_pet);
        lab_contactInfo.setBounds(new Rectangle(12, 0, 660, 124));
        lab_contactInfo.setForeground(Color.GRAY);
        contactInfoPanel.add(lab_contactInfo);
        JButton save_phone = new JButton("Save");
        save_phone.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_phone);
        save_phone.addActionListener(this);
        this.paneObjectAll.put("save_contactList", (Object)save_phone);
    }

    private void initPanel_TrackingSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        JPanel systemsPanel = PanelUtil.createPanel(700, 580);
        JScrollPane trackingScrollPanel = PanelUtil.createScrollPanel(systemsPanel, 5, 5, 760, 510);
        panel.add(trackingScrollPanel);
        JLabel lab_workingMode = new JLabel("Working Mode");
        lab_workingMode.setBounds(new Rectangle(12, 12, 140, 35));
        systemsPanel.add(lab_workingMode);
        JComboBox<String> workMode = new JComboBox<String>(new String[]{"Pet Mode 1", "Pet Mode 2", "Pet Mode 3"});
        workMode.setBounds(new Rectangle(122, 12, 115, 35));
        systemsPanel.add(workMode);
        jsonObj.put("workMode_mode", workMode);
        workMode.addActionListener(this);
        JLabel lab_active = new JLabel("Active Status");
        lab_active.setBounds(new Rectangle(12, 59, 100, 35));
        systemsPanel.add(lab_active);
        PlaceholderTextField input_active1 = new PlaceholderTextField();
        input_active1.setPlaceholder("move");
        input_active1.setBounds(new Rectangle(122, 59, 110, 35));
        PanelUtil.checkInput(input_active1, "^([1-9]\\d|[1-9]\\d{2,8})$", checkArray);
        systemsPanel.add(input_active1);
        jsonObj.put("timeInterval_upload", (Object)input_active1);
        input_active1.addActionListener(this);
        PlaceholderTextField input_active2 = new PlaceholderTextField();
        input_active2.setPlaceholder("no move");
        input_active2.setBounds(new Rectangle(242, 59, 110, 35));
        input_active2.setEditable(false);
        input_active2.setVisible(false);
        systemsPanel.add(input_active2);
        jsonObj.put("timeInterval_upload2", (Object)input_active2);
        input_active1.getDocument().addDocumentListener(new DoubleValue(input_active2));
        JLabel lab_inActive = new JLabel("Inactive Status");
        lab_inActive.setBounds(new Rectangle(12, 106, 100, 35));
        systemsPanel.add(lab_inActive);
        jsonObj.put("timeInterval_lab", (Object)lab_inActive);
        PlaceholderTextField input_inActive1 = new PlaceholderTextField();
        input_inActive1.setPlaceholder("move");
        input_inActive1.setBounds(new Rectangle(122, 106, 110, 35));
        PanelUtil.checkInput(input_inActive1, "^([3-9]\\d{2}|[1-9]\\d{3,8})$", checkArray);
        systemsPanel.add(input_inActive1);
        jsonObj.put("timeInterval_uploadLazy", (Object)input_inActive1);
        PlaceholderTextField input_inActive2 = new PlaceholderTextField();
        input_inActive2.setPlaceholder("no move");
        input_inActive2.setBounds(new Rectangle(242, 106, 110, 35));
        input_inActive2.setEditable(false);
        systemsPanel.add(input_inActive2);
        jsonObj.put("timeInterval_uploadLazy2", (Object)input_inActive2);
        input_inActive1.getDocument().addDocumentListener(new DoubleValue(input_inActive2));
        JPanel timeIntervalPanel = PanelUtil.createPanel("", 12, 153, 340, 176);
        systemsPanel.add(timeIntervalPanel);
        JLabel lab_info = new JLabel(Constants.info1_pet);
        lab_info.setBounds(new Rectangle(0, 0, 300, 166));
        lab_info.setForeground(Color.GRAY);
        JScrollPane infoScroll = PanelUtil.createScrollPanel(lab_info, 0, 0, 340, 176);
        timeIntervalPanel.add(infoScroll);
        this.paneObjectAll.put("lab_infoTimeInterval", (Object)lab_info);
        JLabel lab_timeInterval = new JLabel("Heart-beat interval");
        lab_timeInterval.setBounds(new Rectangle(12, 341, 140, 35));
        systemsPanel.add(lab_timeInterval);
        JToggleButton toggleBtn_heartBeatStatus = new JToggleButton();
        toggleBtn_heartBeatStatus.setIcon(MainPane.toggle_off);
        toggleBtn_heartBeatStatus.setSelectedIcon(MainPane.toggle_on);
        toggleBtn_heartBeatStatus.setBounds(new Rectangle(152, 341, 82, 35));
        systemsPanel.add(toggleBtn_heartBeatStatus);
        jsonObj.put("timeInterval_heartBeatStatus", (Object)toggleBtn_heartBeatStatus);
        PlaceholderTextField input_heartBeat = new PlaceholderTextField();
        input_heartBeat.setPlaceholder("Unit: S/M/H");
        input_heartBeat.setBounds(new Rectangle(244, 341, 110, 35));
        PanelUtil.checkInput(input_heartBeat, CheckDocument.regex_time4, checkArray);
        systemsPanel.add(input_heartBeat);
        jsonObj.put("timeInterval_heartBeat", (Object)input_heartBeat);
        JPanel continuLocatePanel = PanelUtil.createPanel("Live Tracking", 12, 388, 345, 129);
        JLabel lab_time = new JLabel("Time interval");
        lab_time.setBounds(new Rectangle(12, 24, 150, 35));
        continuLocatePanel.add(lab_time);
        PlaceholderTextField input_time = new PlaceholderTextField();
        input_time.setPlaceholder("Unit: S/M/H");
        input_time.setBounds(new Rectangle(162, 24, 160, 35));
        continuLocatePanel.add(input_time);
        PanelUtil.checkInput(input_time, "^([1-9][0-9]|[1-5][0-9][0-9]|600)$", checkArray);
        jsonObj.put("continueLocate_interval", (Object)input_time);
        JLabel lab_last = new JLabel("Duration time");
        lab_last.setBounds(new Rectangle(12, 71, 150, 35));
        continuLocatePanel.add(lab_last);
        PlaceholderTextField input_last = new PlaceholderTextField();
        input_last.setPlaceholder("Unit: S/M/H");
        input_last.setBounds(new Rectangle(162, 71, 160, 35));
        PanelUtil.checkInput(input_last, CheckDocument.regex_time, checkArray);
        continuLocatePanel.add(input_last);
        jsonObj.put("continueLocate_time", (Object)input_last);
        systemsPanel.add(continuLocatePanel);
        JLabel lab_gsmBand = new JLabel("GSM Band");
        lab_gsmBand.setBounds(new Rectangle(12, 529, 120, 35));
        systemsPanel.add(lab_gsmBand);
        JComboBox<String> gsmBand = new JComboBox<String>(new String[]{"0x00-ALL", "0x01-US", "0x02-EUROPE", "0x03-KOREA", "0x04-AUSTRALIA", "0x05-MID_EAST", "0x06-JAPAN", "0x07-CHINA", "0x08-INDIA", "0x09-MEXICO"});
        gsmBand.setBounds(new Rectangle(122, 529, 180, 35));
        systemsPanel.add(gsmBand);
        jsonObj.put("gsmBand", gsmBand);
        String[] lab_systems = new String[]{"APN", "APN User Name", "APN Password", "Server Type", "Server IP", "Server Port"};
        for (int j = 0; j < lab_systems.length; ++j) {
            JLabel lab = new JLabel(lab_systems[j]);
            lab.setBounds(new Rectangle(392, 12 + 47 * j, 140, 35));
            systemsPanel.add(lab);
        }
        String[] input_systems = new String[]{"apn", "apnUserName", "apnPassword", "sever", "sever_ip", "sever_port"};
        for (int j = 0; j < input_systems.length; ++j) {
            if (j == 3) {
                JToggleButton toggleBtn = new JToggleButton();
                toggleBtn.setIcon(MainPane.toggle_off);
                toggleBtn.setSelectedIcon(MainPane.toggle_on);
                toggleBtn.setBounds(new Rectangle(532, 12 + 47 * j, 82, 35));
                systemsPanel.add(toggleBtn);
                jsonObj.put(input_systems[j] + "_status", (Object)toggleBtn);
                JComboBox<String> severType = new JComboBox<String>(new String[]{"TCP", "UDP"});
                severType.setBounds(new Rectangle(624, 12 + 47 * j, 125, 35));
                systemsPanel.add(severType);
                jsonObj.put(input_systems[j] + "_type", severType);
                continue;
            }
            PlaceholderTextField input = new PlaceholderTextField();
            if (j == 0) {
                input.setPlaceholder("0~32 bytes");
                PanelUtil.checkInput(input, "^[\\w\\W]{0,32}$", checkArray);
            } else if (j == 1) {
                input.setPlaceholder("0~16 bytes");
                PanelUtil.checkInput(input, "^[\\w\\W]{0,16}$", checkArray);
            } else if (j == 2) {
                input.setPlaceholder("0~16 bytes");
                PanelUtil.checkInput(input, "^[\\w\\W]{0,16}$", checkArray);
            } else if (j == 4) {
                input.setPlaceholder("0~50 bytes");
                PanelUtil.checkInput(input, "^[\\w\\W]{0,50}$", checkArray);
            } else if (j == 5) {
                input.setPlaceholder("0~65535");
                PanelUtil.checkInput(input, CheckDocument.regex_int, checkArray);
            }
            input.setBounds(new Rectangle(532, 12 + 47 * j, 218, 35));
            systemsPanel.add(input);
            jsonObj.put(input_systems[j], (Object)input);
        }
        JPanel urlPanel = PanelUtil.createPanel("SMS URL", 392, 294, 360, 118);
        JLabel lab_gpsurl = new JLabel("GPS URL");
        lab_gpsurl.setBounds(new Rectangle(12, 24, 100, 35));
        urlPanel.add(lab_gpsurl);
        PlaceholderTextField input_gpsurl = new PlaceholderTextField();
        input_gpsurl.setPlaceholder("0~40 bytes");
        input_gpsurl.setText(Constants.url_gps);
        input_gpsurl.setBounds(new Rectangle(87, 24, 260, 35));
        PanelUtil.checkInput(input_gpsurl, "^[\\w\\W]{0,40}$", checkArray);
        urlPanel.add(input_gpsurl);
        jsonObj.put("smsgpsurl", (Object)input_gpsurl);
        JLabel lab_wifiurl = new JLabel("WIFI URL");
        lab_wifiurl.setBounds(new Rectangle(12, 71, 100, 35));
        urlPanel.add(lab_wifiurl);
        PlaceholderTextField input_wifiurl = new PlaceholderTextField();
        input_wifiurl.setPlaceholder("0~40 bytes");
        input_wifiurl.setText(Constants.url_wifi);
        input_wifiurl.setBounds(new Rectangle(87, 71, 260, 35));
        PanelUtil.checkInput(input_wifiurl, "^[\\w\\W]{0,40}$", checkArray);
        urlPanel.add(input_wifiurl);
        jsonObj.put("smswifiurl", (Object)input_wifiurl);
        systemsPanel.add(urlPanel);
        JPanel agpsLocPanel = PanelUtil.createPanel("AGPS Loc", 392, 412, 360, 71);
        JCheckBox cbox_agps = new JCheckBox("GPS Update");
        cbox_agps.setBounds(new Rectangle(12, 24, 120, 35));
        agpsLocPanel.add(cbox_agps);
        jsonObj.put("agpsLoc_status", (Object)cbox_agps);
        PlaceholderTextField input_agpsLat = new PlaceholderTextField();
        input_agpsLat.setPlaceholder("Latitude");
        input_agpsLat.setBounds(new Rectangle(132, 24, 100, 35));
        PanelUtil.checkInput(input_agpsLat, CheckDocument.regex_lat, checkArray);
        agpsLocPanel.add(input_agpsLat);
        jsonObj.put("agpsLoc_lat", (Object)input_agpsLat);
        PlaceholderTextField input_agpsLng = new PlaceholderTextField();
        input_agpsLng.setPlaceholder("Longitude");
        input_agpsLng.setBounds(new Rectangle(237, 24, 100, 35));
        PanelUtil.checkInput(input_agpsLng, CheckDocument.regex_lng, checkArray);
        agpsLocPanel.add(input_agpsLng);
        jsonObj.put("agpsLoc_lng", (Object)input_agpsLng);
        systemsPanel.add(agpsLocPanel);
        JButton save_systems = new JButton("Save");
        save_systems.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_systems);
        save_systems.addActionListener(this);
        this.paneObjectAll.put("save_tracking", (Object)save_systems);
    }

    private void initPanel_FunctionSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        JPanel functionPanel = PanelUtil.createPanel(700, 500);
        JScrollPane functionScrollPanel = PanelUtil.createScrollPanel(functionPanel, 5, 5, 760, 510);
        panel.add(functionScrollPanel);
        JPanel phonePanel5 = PanelUtil.createPanel("Phone Option", 12, 0, 330, 118);
        functionPanel.add(phonePanel5);
        JRadioButton radio_s5_1 = new JRadioButton("Receive SMS from preset numbers");
        radio_s5_1.setName("s5_1");
        radio_s5_1.setBounds(new Rectangle(12, 24, 280, 35));
        phonePanel5.add(radio_s5_1);
        JRadioButton radio_s5_0 = new JRadioButton("Receive SMS from all numbers");
        radio_s5_0.setName("s5_0");
        radio_s5_0.setBounds(new Rectangle(12, 71, 280, 35));
        phonePanel5.add(radio_s5_0);
        ButtonGroup bg_5 = new ButtonGroup();
        bg_5.add(radio_s5_1);
        bg_5.add(radio_s5_0);
        jsonObj.put("phoneOption_s5", (Object)bg_5);
        JPanel catM = PanelUtil.createPanel("Cat-M Setting", 12, 160, 330, 295);
        functionPanel.add(catM);
        JLabel lab_model = new JLabel("IOT Model");
        lab_model.setBounds(new Rectangle(12, 24, 90, 35));
        catM.add(lab_model);
        JComboBox<String> input_model = new JComboBox<String>(new String[]{"eMTC", "NB-IoT", "eMTC & NB-IOT"});
        input_model.setBounds(new Rectangle(102, 24, 150, 35));
        catM.add(input_model);
        jsonObj.put("catm_iotMode", input_model);
        JLabel lab_ptw1 = new JLabel("eMCT PTW");
        lab_ptw1.setBounds(new Rectangle(12, 71, 90, 35));
        catM.add(lab_ptw1);
        PlaceholderTextField input_ptw1 = new PlaceholderTextField();
        input_ptw1.setPlaceholder("0~255");
        input_ptw1.setBounds(new Rectangle(102, 71, 80, 35));
        PanelUtil.checkInput(input_ptw1, "^\\d{0,255}$", checkArray);
        catM.add(input_ptw1);
        jsonObj.put("catm_emtc", (Object)input_ptw1);
        JLabel lab_value1 = new JLabel("Value");
        lab_value1.setBounds(new Rectangle(192, 71, 60, 35));
        catM.add(lab_value1);
        PlaceholderTextField input_value1 = new PlaceholderTextField();
        input_value1.setPlaceholder("0~255");
        input_value1.setBounds(new Rectangle(232, 71, 80, 35));
        PanelUtil.checkInput(input_value1, "^\\d{0,255}$", checkArray);
        catM.add(input_value1);
        jsonObj.put("catm_emtcValue", (Object)input_value1);
        JLabel lab_ptw2 = new JLabel("NBIOT PTW");
        lab_ptw2.setBounds(new Rectangle(12, 118, 90, 35));
        catM.add(lab_ptw2);
        PlaceholderTextField input_ptw2 = new PlaceholderTextField();
        input_ptw2.setPlaceholder("0~255");
        input_ptw2.setBounds(new Rectangle(102, 118, 80, 35));
        PanelUtil.checkInput(input_ptw2, "^\\d{0,255}$", checkArray);
        catM.add(input_ptw2);
        jsonObj.put("catm_nbiot", (Object)input_ptw2);
        JLabel lab_value2 = new JLabel("Value");
        lab_value2.setBounds(new Rectangle(192, 118, 60, 35));
        catM.add(lab_value2);
        PlaceholderTextField input_value2 = new PlaceholderTextField();
        input_value2.setPlaceholder("0~255");
        input_value2.setBounds(new Rectangle(232, 118, 80, 35));
        PanelUtil.checkInput(input_value2, "^\\d{0,255}$", checkArray);
        catM.add(input_value2);
        jsonObj.put("catm_nbiotValue", (Object)input_value2);
        JLabel lab_gms = new JLabel("GSM");
        lab_gms.setBounds(new Rectangle(12, 165, 90, 35));
        catM.add(lab_gms);
        String[][] arrGSM = new String[][]{{"1", "GSM 900"}, {"2", "GSM 1800"}, {"3", "GSM 850"}, {"4", "GSM 1900"}};
        MultiComboBox gsm = new MultiComboBox(arrGSM);
        gsm.setBounds(new Rectangle(102, 165, 180, 35));
        catM.add(gsm);
        jsonObj.put("catm_gsm", (Object)gsm);
        JLabel lab_eMTCBand = new JLabel("eMTC Band");
        lab_eMTCBand.setBounds(new Rectangle(12, 212, 90, 35));
        catM.add(lab_eMTCBand);
        MultiComboBox eMT_band = new MultiComboBox("B1", "B2", "B3", "B4", "B5", "B8", "B12", "B13", "B14", "B18", "B19", "B20", "B25", "B26", "B27", "B28", "B29", "B31");
        eMT_band.setBounds(new Rectangle(102, 212, 180, 35));
        catM.add(eMT_band);
        jsonObj.put("catm_eMTBand", (Object)eMT_band);
        JLabel lab_NBBand = new JLabel("NB Band");
        lab_NBBand.setBounds(new Rectangle(12, 259, 90, 35));
        catM.add(lab_NBBand);
        MultiComboBox nb_band = new MultiComboBox("B1", "B2", "B3", "B4", "B5", "B8", "B12", "B13", "B14", "B18", "B19", "B20", "B25", "B26", "B27", "B28", "B29", "B31");
        nb_band.setBounds(new Rectangle(102, 259, 180, 35));
        catM.add(nb_band);
        jsonObj.put("catm_nbBand", (Object)nb_band);
        ArrayList<DocumentObject> enableControl = new ArrayList<DocumentObject>(9);
        enableControl.add(new DocumentObject("enableControl_led", "LED", true));
        enableControl.add(new DocumentObject("enableControl_agps", "AGPS", true));
        enableControl.add(new DocumentObject("enableControl_wifiLoc", "WIFI positioning", true));
        enableControl.add(new DocumentObject("enableControl_bleLoc", "Bluetooth positioning", true));
        enableControl.add(new DocumentObject("enableControl_homeBeacon", "Home beacon", true));
        enableControl.add(new DocumentObject("enableControl_activity", "Activity", true));
        enableControl.add(new DocumentObject("enableControl_homeWifi", "Home wifi positioning", true));
        enableControl.add(new DocumentObject("enableControl_step", "Step count", true));
        functionPanel.setPreferredSize(new Dimension(700, enableControl.size() * 47 + 10));
        for (int i = 0; i < enableControl.size(); ++i) {
            if (!((DocumentObject)enableControl.get(i)).getIsShow()) continue;
            JLabel lab = new JLabel(((DocumentObject)enableControl.get(i)).getText());
            lab.setBounds(new Rectangle(370, 12 + 47 * i, 330, 35));
            functionPanel.add(lab);
            JToggleButton toggleBtn = new JToggleButton();
            if (i > 8) {
                toggleBtn.setIcon(MainPane.toggle_no);
                toggleBtn.setSelectedIcon(MainPane.toggle_yes);
            } else {
                toggleBtn.setIcon(MainPane.toggle_off);
                toggleBtn.setSelectedIcon(MainPane.toggle_on);
            }
            toggleBtn.setBounds(new Rectangle(660, 12 + 47 * i, 82, 35));
            functionPanel.add(toggleBtn);
            jsonObj.put(((DocumentObject)enableControl.get(i)).getName(), (Object)toggleBtn);
        }
        JTextField flagValue = new JTextField();
        flagValue.setVisible(false);
        functionPanel.add(flagValue);
        jsonObj.put("enableControl_flagValue", (Object)flagValue);
        JButton save_function = new JButton("Save");
        save_function.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_function);
        save_function.addActionListener(this);
        this.paneObjectAll.put("save_function", (Object)save_function);
    }

    private void initPanel_AlertSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        ArrayList<DocumentObject> document_alert = new ArrayList<DocumentObject>(6);
        document_alert.add(new DocumentObject("geoAlert$0", "GEO NO.1", true));
        document_alert.add(new DocumentObject("geoAlert$1", "GEO NO.2", true));
        document_alert.add(new DocumentObject("geoAlert$2", "GEO NO.3", true));
        document_alert.add(new DocumentObject("geoAlert$3", "GEO NO.4", true));
        document_alert.add(new DocumentObject("noMotionAlert", "No-Motion Alert", true));
        document_alert.add(new DocumentObject("powerLowAlert", "Low Power Alert", true));
        for (int i = 0; i < document_alert.size(); ++i) {
            if (!((DocumentObject)document_alert.get(i)).getIsShow()) continue;
            JLabel lab = new JLabel(((DocumentObject)document_alert.get(i)).getText());
            lab.setBounds(new Rectangle(12, 12 + 47 * i, 110, 35));
            panel.add(lab);
            JToggleButton toggleBtn = new JToggleButton();
            toggleBtn.setIcon(MainPane.toggle_off);
            toggleBtn.setSelectedIcon(MainPane.toggle_on);
            toggleBtn.setBounds(new Rectangle(122, 12 + 47 * i, 82, 35));
            panel.add(toggleBtn);
            jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_status", (Object)toggleBtn);
            if (i < 4) {
                JComboBox<String> geoDirection = new JComboBox<String>(new String[]{"OUT", "IN"});
                geoDirection.setBounds(new Rectangle(214, 12 + 47 * i, 75, 35));
                panel.add(geoDirection);
                jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_direction", geoDirection);
                JComboBox<String> geoType = new JComboBox<String>(new String[]{"Circle", "Polygon"});
                geoType.setEnabled(false);
                geoType.setBounds(new Rectangle(294, 12 + 47 * i, 105, 35));
                panel.add(geoType);
                jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_type", geoType);
                geoType.addActionListener(this);
                PlaceholderTextField input = new PlaceholderTextField();
                input.setPlaceholder("Radius");
                input.setBounds(new Rectangle(404, 12 + 47 * i, 75, 35));
                PanelUtil.checkInput(input, CheckDocument.regex_int, checkArray);
                panel.add(input);
                jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_radius", (Object)input);
                PlaceholderTextField input2 = new PlaceholderTextField();
                input2.setPlaceholder("Latitude and Longitude");
                input2.setEditable(false);
                input2.setBounds(new Rectangle(484, 12 + 47 * i, 218, 35));
                panel.add(input2);
                jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_latlng", (Object)input2);
                JButton buttonEdit = new JButton();
                buttonEdit.setBounds(new Rectangle(709, 12 + 47 * i, 35, 35));
                buttonEdit.setIcon(MainPane.editIcon);
                buttonEdit.setPressedIcon(MainPane.editIcon);
                panel.add(buttonEdit);
                buttonEdit.addActionListener(this);
                jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_edit", (Object)buttonEdit);
                continue;
            }
            if (i == 4) {
                PlaceholderTextField input_time = new PlaceholderTextField();
                input_time.setPlaceholder("No move duration time");
                input_time.setBounds(new Rectangle(214, 12 + 47 * i, 178, 35));
                PanelUtil.checkInput(input_time, CheckDocument.regex_time3, checkArray);
                panel.add(input_time);
                jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_time", (Object)input_time);
                continue;
            }
            if (i != 5) continue;
            PlaceholderTextField input = new PlaceholderTextField();
            input.setPlaceholder("Power low alert 10~50%");
            input.setBounds(new Rectangle(214, 12 + 47 * i, 178, 35));
            PanelUtil.checkInput(input, "^([1-4][0-9]|50)$", checkArray);
            panel.add(input);
            jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_power", (Object)input);
            JCheckBox cbox_powerON = new JCheckBox("Power ON");
            cbox_powerON.setBounds(new Rectangle(402, 12 + 47 * i, 120, 35));
            panel.add(cbox_powerON);
            jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_powerON", (Object)cbox_powerON);
            JTextField input_voice = new JTextField("");
            input_voice.setVisible(false);
            input_voice.setBounds(new Rectangle(214, 12 + 47 * (i + 1), 178, 35));
            panel.add(input_voice);
            jsonObj.put(((DocumentObject)document_alert.get(i)).getName() + "_voice", (Object)input_voice);
        }
        JButton save_alert = new JButton("Save");
        save_alert.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_alert);
        save_alert.addActionListener(this);
        this.paneObjectAll.put("save_alert_settings", (Object)save_alert);
    }

    private void initPanel_BeaconSetting(JPanel panel, JSONObject jsonObj) {
        JLabel lab;
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        PlaceholderTextField beacon_lat = new PlaceholderTextField();
        beacon_lat.setPlaceholder("Latitude");
        beacon_lat.setBounds(new Rectangle(268, 12, 100, 35));
        PanelUtil.checkInput(beacon_lat, CheckDocument.regex_lat, checkArray);
        panel.add(beacon_lat);
        this.paneObjectAll.put("beacon_lat", (Object)beacon_lat);
        PlaceholderTextField beacon_lng = new PlaceholderTextField();
        beacon_lng.setPlaceholder("Longitude");
        beacon_lng.setBounds(new Rectangle(378, 12, 100, 35));
        PanelUtil.checkInput(beacon_lng, CheckDocument.regex_lng, checkArray);
        panel.add(beacon_lng);
        this.paneObjectAll.put("beacon_lng", (Object)beacon_lng);
        PlaceholderTextField beacon_describe = new PlaceholderTextField();
        beacon_describe.setPlaceholder("Description");
        beacon_describe.setBounds(new Rectangle(488, 12, 160, 35));
        PanelUtil.checkInput(beacon_describe, "^[\\w\\W]{0,16}$", checkArray);
        panel.add(beacon_describe);
        this.paneObjectAll.put("beacon_describe", (Object)beacon_describe);
        JButton beacon_scan = new JButton("Scan");
        beacon_scan.setBounds(new Rectangle(658, 12, 82, 35));
        panel.add(beacon_scan);
        this.paneObjectAll.put("beacon_scan", (Object)beacon_scan);
        beacon_scan.addActionListener(this);
        JPanel beaconPanel = PanelUtil.createPanel(700, 950);
        JScrollPane beaconScrollPanel = PanelUtil.createScrollPanel(beaconPanel, 5, 57, 760, 458);
        panel.add(beaconScrollPanel);
        for (int i = 0; i < 20; ++i) {
            lab = new JLabel("B" + (i + 1));
            lab.setBounds(new Rectangle(12, 12 + 47 * i, 60, 35));
            beaconPanel.add(lab);
            String beaconListKey = "beaconList$" + i;
            PlaceholderTextField input_mac = new PlaceholderTextField();
            input_mac.setPlaceholder("Beacon Mac");
            input_mac.setBounds(new Rectangle(52, 12 + 47 * i, 198, 35));
            PanelUtil.checkInput(input_mac, CheckDocument.regex_mac, checkArray);
            beaconPanel.add(input_mac);
            jsonObj.put(beaconListKey + "_mac", (Object)input_mac);
            PlaceholderTextField input_lat = new PlaceholderTextField();
            input_lat.setPlaceholder("Latitude");
            input_lat.setBounds(new Rectangle(262, 12 + 47 * i, 100, 35));
            PanelUtil.checkInput(input_lat, CheckDocument.regex_lat, checkArray);
            beaconPanel.add(input_lat);
            jsonObj.put(beaconListKey + "_lat", (Object)input_lat);
            PlaceholderTextField input_lng = new PlaceholderTextField();
            input_lng.setPlaceholder("Longitude");
            input_lng.setBounds(new Rectangle(372, 12 + 47 * i, 100, 35));
            PanelUtil.checkInput(input_lng, CheckDocument.regex_lng, checkArray);
            beaconPanel.add(input_lng);
            jsonObj.put(beaconListKey + "_lng", (Object)input_lng);
            PlaceholderTextField input_describe = new PlaceholderTextField();
            input_describe.setPlaceholder("Description");
            input_describe.setBounds(new Rectangle(482, 12 + 47 * i, 160, 35));
            PanelUtil.checkInput(input_describe, "^[\\w\\W]{0,16}$", checkArray);
            beaconPanel.add(input_describe);
            jsonObj.put(beaconListKey + "_describe", (Object)input_describe);
            JToggleButton toggleBtn = new JToggleButton();
            toggleBtn.setIcon(MainPane.toggle_off);
            toggleBtn.setSelectedIcon(MainPane.toggle_on);
            toggleBtn.setBounds(new Rectangle(652, 12 + 47 * i, 82, 35));
            beaconPanel.add(toggleBtn);
            jsonObj.put(beaconListKey + "_enable", (Object)toggleBtn);
        }
        JButton save_beacon = new JButton("Save");
        save_beacon.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_beacon);
        save_beacon.addActionListener(this);
        this.paneObjectAll.put("save_home_beacon", (Object)save_beacon);
        lab = PanelUtil.createLabel("Select All", 592, 525, 70, 35);
        panel.add(lab);
        JToggleButton toggleBtn = PanelUtil.createToggleButton(662, 525, 82, 35);
        toggleBtn.setIcon(MainPane.toggle_off);
        toggleBtn.setSelectedIcon(MainPane.toggle_on);
        panel.add(toggleBtn);
        toggleBtn.addActionListener(this);
        this.paneObjectAll.put("SelectAllBeacon", (Object)toggleBtn);
    }

    private void initPanel_HomeWiFi(JPanel panel, JSONObject jsonObj) {
        JLabel lab;
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        PlaceholderTextField wifi_lat = new PlaceholderTextField();
        wifi_lat.setPlaceholder("Latitude");
        wifi_lat.setBounds(new Rectangle(268, 12, 100, 35));
        PanelUtil.checkInput(wifi_lat, CheckDocument.regex_lat, checkArray);
        panel.add(wifi_lat);
        this.paneObjectAll.put("wifi_lat", (Object)wifi_lat);
        PlaceholderTextField wifi_lng = new PlaceholderTextField();
        wifi_lng.setPlaceholder("Longitude");
        wifi_lng.setBounds(new Rectangle(378, 12, 100, 35));
        PanelUtil.checkInput(wifi_lng, CheckDocument.regex_lng, checkArray);
        panel.add(wifi_lng);
        this.paneObjectAll.put("wifi_lng", (Object)wifi_lng);
        PlaceholderTextField wifi_describe = new PlaceholderTextField();
        wifi_describe.setPlaceholder("Description");
        wifi_describe.setBounds(new Rectangle(488, 12, 160, 35));
        PanelUtil.checkInput(wifi_describe, "^[\\w\\W]{0,16}$", checkArray);
        panel.add(wifi_describe);
        this.paneObjectAll.put("wifi_describe", (Object)wifi_describe);
        JButton wifi_scanAuto = new JButton("Scan Auto");
        wifi_scanAuto.setBounds(new Rectangle(658, 12, 97, 35));
        panel.add(wifi_scanAuto);
        this.paneObjectAll.put("wifi_scanAuto", (Object)wifi_scanAuto);
        wifi_scanAuto.addActionListener(this);
        JButton wifi_scan = new JButton("Scan");
        wifi_scan.setBounds(new Rectangle(12, 12, 82, 35));
        panel.add(wifi_scan);
        this.paneObjectAll.put("wifi_scan", (Object)wifi_scan);
        wifi_scan.addActionListener(this);
        JPanel wifiPanel = PanelUtil.createPanel(700, 500);
        JScrollPane wifiScrollPanel = PanelUtil.createScrollPanel(wifiPanel, 5, 57, 760, 458);
        panel.add(wifiScrollPanel);
        for (int i = 0; i < 10; ++i) {
            lab = new JLabel("W" + (i + 1));
            lab.setBounds(new Rectangle(12, 12 + 47 * i, 60, 35));
            wifiPanel.add(lab);
            String wifiWhiteListKey = "wifiWhiteList$" + i;
            PlaceholderTextField input_mac = new PlaceholderTextField();
            input_mac.setPlaceholder("WiFi Mac");
            input_mac.setBounds(new Rectangle(52, 12 + 47 * i, 198, 35));
            PanelUtil.checkInput(input_mac, CheckDocument.regex_mac, checkArray);
            wifiPanel.add(input_mac);
            jsonObj.put(wifiWhiteListKey + "_mac", (Object)input_mac);
            PlaceholderTextField input_lat = new PlaceholderTextField();
            input_lat.setPlaceholder("Latitude");
            input_lat.setBounds(new Rectangle(262, 12 + 47 * i, 100, 35));
            PanelUtil.checkInput(input_lat, CheckDocument.regex_lat, checkArray);
            wifiPanel.add(input_lat);
            jsonObj.put(wifiWhiteListKey + "_lat", (Object)input_lat);
            PlaceholderTextField input_lng = new PlaceholderTextField();
            input_lng.setPlaceholder("Longitude");
            input_lng.setBounds(new Rectangle(372, 12 + 47 * i, 100, 35));
            PanelUtil.checkInput(input_lng, CheckDocument.regex_lng, checkArray);
            wifiPanel.add(input_lng);
            jsonObj.put(wifiWhiteListKey + "_lng", (Object)input_lng);
            PlaceholderTextField input_describe = new PlaceholderTextField();
            input_describe.setPlaceholder("Description");
            input_describe.setBounds(new Rectangle(482, 12 + 47 * i, 160, 35));
            PanelUtil.checkInput(input_describe, "^[\\w\\W]{0,16}$", checkArray);
            wifiPanel.add(input_describe);
            jsonObj.put(wifiWhiteListKey + "_describe", (Object)input_describe);
            JToggleButton toggleBtn = new JToggleButton();
            toggleBtn.setIcon(MainPane.toggle_off);
            toggleBtn.setSelectedIcon(MainPane.toggle_on);
            toggleBtn.setBounds(new Rectangle(652, 12 + 47 * i, 82, 35));
            wifiPanel.add(toggleBtn);
            jsonObj.put(wifiWhiteListKey + "_enable", (Object)toggleBtn);
        }
        JButton save_wifi = new JButton("Save");
        save_wifi.setBounds(new Rectangle(12, 525, 85, 35));
        panel.add(save_wifi);
        save_wifi.addActionListener(this);
        this.paneObjectAll.put("save_home_wifi", (Object)save_wifi);
        lab = PanelUtil.createLabel("Select All", 592, 525, 70, 35);
        panel.add(lab);
        JToggleButton toggleBtn = PanelUtil.createToggleButton(662, 525, 82, 35);
        toggleBtn.setIcon(MainPane.toggle_off);
        toggleBtn.setSelectedIcon(MainPane.toggle_on);
        panel.add(toggleBtn);
        toggleBtn.addActionListener(this);
        this.paneObjectAll.put("SelectAllHomeWiFi", (Object)toggleBtn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JToggleButton mon;
        String beaconListKey;
        byte[] sendData;
        this.panels.forEach((key, value) -> {
            if (e.getSource().equals(this.paneObjectAll.get(key))) {
                if (this.isGlobalCheckError && PanelUtil.checkError(this.paneObjectAll, value)) {
                    return;
                }
                this.savePanel(PanelUtil.getPanel(value));
            }
        });
        if (e.getSource().equals(this.paneObjectAll.get((Object)"beacon_scan"))) {
            JTextField beacon_lat = (JTextField)this.paneObjectAll.get((Object)"beacon_lat");
            JTextField beacon_lng = (JTextField)this.paneObjectAll.get((Object)"beacon_lng");
            JTextField beacon_describe = (JTextField)this.paneObjectAll.get((Object)"beacon_describe");
            sendData = CMD_Public.scanBeacon(beacon_lat.getText(), beacon_lng.getText(), beacon_describe.getText());
            MainPane.sendData(sendData);
        } else if (e.getSource().equals(this.paneObjectAll.get((Object)"wifi_scanAuto"))) {
            JTextField wifi_lat = (JTextField)this.paneObjectAll.get((Object)"wifi_lat");
            JTextField wifi_lng = (JTextField)this.paneObjectAll.get((Object)"wifi_lng");
            JTextField wifi_describe = (JTextField)this.paneObjectAll.get((Object)"wifi_describe");
            sendData = CMD_Public.scanWifiAuto(wifi_lat.getText(), wifi_lng.getText(), wifi_describe.getText());
            MainPane.sendData(sendData);
        } else if (e.getSource().equals(this.paneObjectAll.get((Object)"wifi_scan"))) {
            PublicUtil.readConfig(new byte[]{98});
            SwingUtilities.invokeLater(() -> {
                ScanWiFiJDialog scanWiFi = ScanWiFiJDialog.getInstance();
                scanWiFi.setParam((Map<String, Object>)this.paneWifiList);
                scanWiFi.setVisible(true);
            });
        } else if (e.getSource().equals(this.paneSystems.get((Object)"workMode_mode"))) {
            JComboBox workMode = (JComboBox)this.paneSystems.get((Object)"workMode_mode");
            JTextField active1 = (JTextField)this.paneSystems.get((Object)"timeInterval_upload");
            JTextField active2 = (JTextField)this.paneSystems.get((Object)"timeInterval_upload2");
            JLabel lab = (JLabel)this.paneSystems.get((Object)"timeInterval_lab");
            JTextField inActive1 = (JTextField)this.paneSystems.get((Object)"timeInterval_uploadLazy");
            JTextField inActive2 = (JTextField)this.paneSystems.get((Object)"timeInterval_uploadLazy2");
            JLabel lab_info = (JLabel)this.paneObjectAll.get((Object)"lab_infoTimeInterval");
            if (workMode.getSelectedIndex() == 0) {
                active1.setVisible(true);
                active2.setVisible(false);
                lab.setVisible(true);
                inActive1.setVisible(true);
                inActive2.setVisible(true);
                lab_info.setText(Constants.info1_pet);
            } else if (workMode.getSelectedIndex() == 1) {
                active1.setVisible(true);
                active2.setVisible(true);
                lab.setVisible(true);
                inActive1.setVisible(true);
                inActive2.setVisible(true);
                lab_info.setText(Constants.info2_pet);
            } else if (workMode.getSelectedIndex() == 2) {
                active1.setVisible(true);
                active2.setVisible(false);
                lab.setVisible(false);
                inActive1.setVisible(false);
                inActive2.setVisible(false);
                lab_info.setText(Constants.info3);
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (e.getSource().equals(this.paneAlert.get((Object)("geoAlert$" + i + "_type")))) {
                PublicUtil.changeGeoType(this.paneAlert, i);
            }
            if (!e.getSource().equals(this.paneAlert.get((Object)("geoAlert$" + i + "_edit")))) continue;
            PublicUtil.showGeoEditPage(this.paneAlert, i);
        }
        if (e.getSource().equals(this.paneObjectAll.get((Object)"SelectAllBeacon"))) {
            JToggleButton everyday = (JToggleButton)this.paneObjectAll.getObject("SelectAllBeacon", JToggleButton.class);
            for (int i = 0; i < 20; ++i) {
                beaconListKey = "beaconList$" + i;
                mon = (JToggleButton)this.paneBeacon.getObject(beaconListKey + "_enable", JToggleButton.class);
                mon.setSelected(everyday.isSelected());
            }
        }
        if (e.getSource().equals(this.paneObjectAll.get((Object)"SelectAllHomeWiFi"))) {
            JToggleButton everyday = (JToggleButton)this.paneObjectAll.getObject("SelectAllHomeWiFi", JToggleButton.class);
            for (int i = 0; i < 10; ++i) {
                beaconListKey = "wifiWhiteList$" + i;
                mon = (JToggleButton)this.paneWifiList.getObject(beaconListKey + "_enable", JToggleButton.class);
                mon.setSelected(everyday.isSelected());
            }
        }
    }

    public void saveAll() {
        JSONObject configData = new JSONObject();
        for (JSONObject paneObject : this.panels.values()) {
            configData.putAll((Map)PanelUtil.getPanel(paneObject));
        }
        JSONObject[] jsonObjs = this.panels.values().toArray(new JSONObject[this.panels.size()]);
        if (this.isGlobalCheckError && PanelUtil.checkError(this.paneObjectAll, jsonObjs)) {
            return;
        }
        this.savePanel(configData);
    }

    public void savePanel(JSONObject configData) {
        HandlerChain.Builder(configData).addHandler(new HandlerRemoveField()).addHandler(new HandlerNoMotionTime()).addHandler(new HandlerListMap()).handleResponse();
        PublicUtil.savePanel(configData);
    }

    public void clearAll() {
        for (JSONObject paneObject : this.panels.values()) {
            PublicUtil.clearPanel((Map<String, Object>)paneObject);
        }
        BottomStatusPanel.setBattery(-1);
    }

    @Override
    public void listenReceiveData(CmdData cmdData) {
        MainPane.getDebugModel().listenReceiveData(cmdData);
        if ("R".equals(cmdData.getDateType())) {
            JSONObject responseData;
            JSONObject data_json = new JSONObject((Map)cmdData.getData());
            JSONObject dataClone = JSONObject.parseObject((String)data_json.toJSONString());
            JSONObject cmdBodyData = dataClone.getJSONObject("cmdBodyData");
            JSONObject configData = cmdBodyData.getJSONObject("configData");
            if (!this.isShow_Model) {
                configData.remove((Object)"deviceName");
            }
            if (configData != null) {
                HandlerChain.Builder(configData).addHandler(new HandlerListMap()).addHandler(new HandlerNoMotionTime()).handleRequest();
                for (JSONObject paneObject : this.panels.values()) {
                    PanelUtil.showPaneData(paneObject, configData);
                }
                BottomStatusPanel.setBattery(configData.getIntValue("battery_battery"));
                MessageDialog.show(MainPane.getThisModel(), "Read successfully.", 1000L);
            }
            if ((responseData = cmdBodyData.getJSONObject("responseData")) != null) {
                int code = Integer.parseInt(responseData.getString("code"));
                PanelUtil.showPasswordJDialog(code);
                Object returnMsg = responseData.getString("returnStatus");
                if (((String)returnMsg).equals("ok")) {
                    returnMsg = "OK";
                } else if (((String)returnMsg).equals("error")) {
                    returnMsg = "ERROR:" + responseData.getString("msg");
                    if (responseData.getIntValue("code") == 22) {
                        returnMsg = "OK";
                    }
                }
                MessageDialog.show(MainPane.getThisModel(), (String)returnMsg, 2000L);
            }
        }
    }

    @Override
    public void readProfile() {
        JSONObject configData = PublicUtil.readProfile();
        HandlerChain.Builder(configData).addHandler(new HandlerListMap()).addHandler(new HandlerNoMotionTime()).handleRequest();
        for (JSONObject paneObject : this.panels.values()) {
            PanelUtil.showPaneData(paneObject, configData);
        }
    }

    @Override
    public void writeProfile() {
        JSONObject configData = new JSONObject();
        for (JSONObject paneObject : this.panels.values()) {
            configData.putAll((Map)PanelUtil.getPanel(paneObject));
        }
        HandlerChain.Builder(configData).addHandler(new HandlerRemoveField()).addHandler(new HandlerNoMotionTime()).addHandler(new HandlerListMap()).handleResponse();
        PublicUtil.writeProfile(configData);
    }

    @Override
    public void setConfigFile() {
        Constants.configFileUtil.setProperty(this.getKey(), "isShow_Model", "true");
        Constants.configFileUtil.setProperty(this.getKey(), "checkError", "false");
    }
}

