/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.netty;

import com.eview.tool.model.Model_Debug;
import com.eview.tool.netty.NettyServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.log4j.Logger;

public class NettyServer
extends Thread {
    private Logger log = Logger.getLogger(this.getClass());
    private int port = 5050;
    private static boolean isConnection = false;
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workGroup = new NioEventLoopGroup();
    private ChannelFuture future;
    public static ChannelGroup channels = new DefaultChannelGroup("ChannelGroups", (EventExecutor)GlobalEventExecutor.INSTANCE);

    public NettyServer(int port) {
        this.port = port;
    }

    public static boolean isConnection() {
        return isConnection;
    }

    @Override
    public void run() {
        try {
            ServerBootstrap bootstrap_tcp = new ServerBootstrap();
            bootstrap_tcp.group(this.bossGroup, this.workGroup);
            bootstrap_tcp.channel(NioServerSocketChannel.class);
            bootstrap_tcp.option(ChannelOption.SO_BACKLOG, (Object)1024);
            bootstrap_tcp.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            bootstrap_tcp.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap_tcp.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap_tcp.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            bootstrap_tcp.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(300)});
                    pipeline.addLast(new ChannelHandler[]{new NettyServerHandler()});
                    pipeline.addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
                    pipeline.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                    pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 2, 2, -8, 0)});
                }
            });
            this.future = bootstrap_tcp.bind(this.port).sync();
            if (this.future.isSuccess()) {
                isConnection = true;
                Model_Debug.mock_socket_connection.setText("Disconnect");
                Model_Debug.mock_tcpType.setEnabled(false);
                Model_Debug.mock_host.setEnabled(false);
                Model_Debug.mock_port.setEnabled(false);
                this.log.debug((Object)("TcpServer Start successfully, host\uff1a" + this.port));
            }
            this.future.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().close();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"NettyServer Exception:", (Throwable)e);
        }
    }

    public void sendData(byte[] data) {
        System.out.println("channels.size()==" + channels.size() + " data.length==" + data.length);
        channels.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])data));
    }

    public void shutdown() {
        isConnection = false;
        if (this.workGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.workGroup.shutdownGracefully();
            Model_Debug.mock_socket_connection.setText("Connection");
            Model_Debug.mock_tcpType.setEnabled(true);
            Model_Debug.mock_host.setEnabled(true);
            Model_Debug.mock_port.setEnabled(true);
            this.log.debug((Object)"NettyServer stoped.");
        }
    }
}

