/*
 * Decompiled with CFR 0.152.
 */
package com.eview.util;

import com.eview.util.Constants;
import com.eview.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class DriverFile {
    private static final Logger log = Logger.getLogger(DriverFile.class);
    private static String osName;
    private static String osArch;
    private static String osVersion;

    public static void loadDriver() {
        String fs = System.getProperty("file.separator");
        osName = System.getProperty("os.name").toLowerCase();
        osArch = System.getProperty("os.arch").toLowerCase();
        osVersion = System.getProperty("os.version").toLowerCase();
        log.info((Object)("The current operating system : osName=" + osName + " osArch=" + osArch + " osVersion=" + osVersion));
        log.info((Object)("JDK Path:" + System.getProperty("java.home")));
        if (osName.indexOf("windows") >= 0) {
            String driverPath = "/windows/" + osArch + "/serial/";
            String driverFile = Constants.currentPath + fs + "rxtxParallel.dll";
            if (DriverFile.isCopy(driverFile)) {
                InputStream inputStream = DriverFile.class.getResourceAsStream(driverPath + "rxtxParallel.dll");
                FileUtil.copyFile(inputStream, Constants.currentPath + fs + "rxtxParallel.dll");
                InputStream inputStream2 = DriverFile.class.getResourceAsStream(driverPath + "rxtxSerial.dll");
                FileUtil.copyFile(inputStream2, Constants.currentPath + fs + "rxtxSerial.dll");
            }
        } else if (osName.indexOf("mac") >= 0 && osName.indexOf("os") > 0 && osName.indexOf("x") > 0) {
            String driverPath = "/mac_os_x/serial/";
            String driverFile = Constants.currentPath + fs + "librxtxSerial.jnilib";
            if (DriverFile.isCopy(driverFile)) {
                InputStream inputStream = DriverFile.class.getResourceAsStream(driverPath + "librxtxSerial.jnilib");
                FileUtil.copyFile(inputStream, driverFile);
            }
        }
        Constants.configFileUtil.writeProperty("DriverFile", "osName", osName);
        Constants.configFileUtil.writeProperty("DriverFile", "osArch", osArch);
    }

    private static boolean isCopy(String fileName) {
        File driverFile = new File(fileName);
        if (!driverFile.exists()) {
            return true;
        }
        String config_osName = Constants.configFileUtil.readProperty("DriverFile", "osName", "");
        String config_osArch = Constants.configFileUtil.readProperty("DriverFile", "osArch", "");
        return !osName.equals(config_osName) || !osArch.equals(config_osArch);
    }
}

