/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import com.alibaba.fastjson.JSONObject;
import com.eview.tool.MainPane;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FactoryMadeJDialog
extends JDialog
implements ActionListener {
    private static JButton make = new JButton("Make profile");
    private static JButton select = new JButton("Select profile");
    private static JTextField input = new JTextField();
    private static JButton save = new JButton("Save to device");
    private static FactoryMadeJDialog instance = new FactoryMadeJDialog();

    public static FactoryMadeJDialog getInstance() {
        return instance;
    }

    private FactoryMadeJDialog() {
        this.setTitle("Factory make profile");
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(null);
        Container desktopPane = this.getContentPane();
        contentPane.add((Component)desktopPane, "Center");
        this.setContentPane(contentPane);
        this.setBounds(new Rectangle(0, 0, 380, 200));
        this.setLocationRelativeTo(null);
        input.setBounds(new Rectangle(5, 40, 230, 30));
        input.setEditable(false);
        contentPane.add(input);
        select.setBounds(new Rectangle(240, 40, 120, 30));
        contentPane.add(select);
        make.setBounds(new Rectangle(5, 85, 120, 30));
        contentPane.add(make);
        save.setBounds(new Rectangle(230, 85, 130, 30));
        contentPane.add(save);
        make.addActionListener(this);
        select.addActionListener(this);
        save.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == make) {
            SwingUtilities.invokeLater(() -> {
                PublicUtil.readConfig(null);
                Map<String, Object> configData = MainPane.receiveData(MainPane.sequenceId, 3000L);
                JSONObject jsonObject = new JSONObject(configData);
                PublicUtil.writeProfile(jsonObject.getJSONObject("cmdBodyData").getJSONObject("configData"));
            });
        }
        if (e.getSource() == select) {
            String filePath = Constants.configFileUtil.readProperty(MainPane.getThisModel().getKey(), "UpgradeFilePath", ".");
            JFileChooser chooser = new JFileChooser(filePath);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("*.bin,*.config", "bin", "config");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                String path = chooser.getSelectedFile().getPath();
                Constants.configFileUtil.writeProperty(MainPane.getThisModel().getKey(), "UpgradeFilePath", path);
                input.setText(path);
            }
        }
        if (e.getSource() == save) {
            String path = input.getText();
            Constants.configFileUtil.writeProperty(MainPane.getThisModel().getKey(), "readProfile", path);
            try {
                byte[] data = Files.readAllBytes(new File(path).toPath());
                Map mapData = (Map)MainPane.protocol.protocolAnalysis(data).get(0);
                JSONObject data_json = new JSONObject(mapData);
                JSONObject configData = data_json.getJSONObject("cmdBodyData").getJSONObject("configData");
                if (configData != null) {
                    System.out.println("configData=>" + String.valueOf(configData));
                    PublicUtil.savePanel(configData);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

