/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import com.alibaba.fastjson.JSONObject;
import com.eview.hid.UsbHidServices;
import com.eview.tool.MainPane;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.event.RD_ObserverCallBack;
import com.tracker.event.ReturnDataUtil;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hid4java.HidDevice;

public class ModuleUpgrade
extends Thread {
    private final Logger log = Logger.getLogger(this.getClass());
    public static final int CMD_Debug = 6;
    public static final int CMD_Module_Start = 84;
    private byte[] firmwareData;
    private HidDevice hidDevice;
    private boolean isRunning = true;
    private int state = 1;
    private RD_ObserverCallBack observer;
    private UsbHidServices usbHidServices = UsbHidServices.getInstance();

    public ModuleUpgrade(byte[] data, HidDevice hidDevice) {
        this.firmwareData = data;
        this.hidDevice = hidDevice;
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.subscription();
        this.usbHidServices.sendMessage(this.hidDevice, this.moduleUpgrade1());
        this.state = 2;
    }

    public void subscription() {
        String[] keys = new String[]{"data_hid" + this.hidDevice.hashCode()};
        this.observer = ReturnDataUtil.getObserverData((String[])keys, (object, condition) -> {
            JSONObject jsonData = null;
            if ("R".equals(condition.getDateType())) {
                jsonData = new JSONObject((Map)object);
            }
            if (jsonData != null) {
                String content;
                String hexStr;
                JSONObject cmdBodyData = jsonData.getJSONObject("cmdBodyData");
                if (this.state == 2 && cmdBodyData.getIntValue("cmdType") == 6) {
                    String content2;
                    String hexStr2 = cmdBodyData.getJSONObject("debugData").getJSONObject("UnsupportedKeys").getString("key:0x53");
                    if (hexStr2 != null && (content2 = BytesHexStrUtil.bytes2StringByUTF_8((byte[])BytesHexStrUtil.hexStringToBytes((String)(hexStr2 = hexStr2.replace("Value:", ""))))).contains("APP RDY")) {
                        MainPane.delay(1000L);
                        this.usbHidServices.sendMessage(this.hidDevice, this.moduleUpgrade2(this.firmwareData.length));
                        this.state = 3;
                    }
                } else if (this.state == 3 && cmdBodyData.getIntValue("cmdType") == 6) {
                    String content3;
                    String hexStr3 = cmdBodyData.getJSONObject("debugData").getJSONObject("UnsupportedKeys").getString("key:0x53");
                    if (hexStr3 != null && (content3 = BytesHexStrUtil.bytes2StringByUTF_8((byte[])BytesHexStrUtil.hexStringToBytes((String)(hexStr3 = hexStr3.replace("Value:", ""))))).contains("CONNECT")) {
                        this.state = 4;
                        MainPane.delay(2000L);
                        this.sendUpgradeData();
                    }
                } else if (this.state == 4 && cmdBodyData.getIntValue("cmdType") == 6) {
                    String content4;
                    String hexStr4 = cmdBodyData.getJSONObject("debugData").getJSONObject("UnsupportedKeys").getString("key:0x53");
                    if (hexStr4 != null && (content4 = BytesHexStrUtil.bytes2StringByUTF_8((byte[])BytesHexStrUtil.hexStringToBytes((String)(hexStr4 = hexStr4.replace("Value:", ""))))).contains("+QFOTADL: " + this.firmwareData.length)) {
                        this.usbHidServices.sendMessage(this.hidDevice, this.moduleUpgrade4());
                        this.state = 5;
                    }
                } else if (this.state == 5 && cmdBodyData.getIntValue("cmdType") == 6 && (hexStr = cmdBodyData.getJSONObject("debugData").getJSONObject("UnsupportedKeys").getString("key:0x53")) != null && (content = BytesHexStrUtil.bytes2StringByUTF_8((byte[])BytesHexStrUtil.hexStringToBytes((String)(hexStr = hexStr.replace("Value:", ""))))).contains("+QIND: \"FOTA\",\"END\",0")) {
                    this.usbHidServices.sendMessage(this.hidDevice, this.moduleUpgrade5());
                }
            }
        });
    }

    public void unSubscription() {
        if (this.observer != null) {
            ReturnDataUtil.deleteObserverData((String)("data_hid" + this.hidDevice.hashCode()), (RD_ObserverCallBack)this.observer);
        }
    }

    public void sendUpgradeData() {
        int address = 0;
        int bufferSize = 3600;
        int percent_temp = 0;
        while (this.isRunning && address < this.firmwareData.length) {
            byte[] buffer = bufferSize > this.firmwareData.length - address ? Arrays.copyOfRange(this.firmwareData, address, this.firmwareData.length) : Arrays.copyOfRange(this.firmwareData, address, address + bufferSize);
            MainPane.delay(430L);
            this.usbHidServices.sendMessage(this.hidDevice, this.moduleUpgrade3(buffer));
            int percent = Math.round((float)(address += buffer.length) / (float)this.firmwareData.length * 100.0f);
            if (percent <= percent_temp || percent % 5 != 2 && percent != 100) continue;
            percent_temp = percent;
            StringBuilder progress = new StringBuilder().append(this.firmwareData.length).append("/").append(address).append(" Percent:").append(percent_temp).append("%\r\n");
            OutputLog outputLog = new OutputLog().setType("S").setChannel(Integer.toString(this.hidDevice.hashCode())).setData(progress.toString()).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextArea(Model_Debug.debug_outputArea);
            OutputLogQueue.getInstance().addDebugLog(outputLog);
        }
    }

    public void closeThread() {
        this.isRunning = false;
        this.unSubscription();
    }

    public byte[] moduleUpgrade1() {
        OutputLog outputLog = new OutputLog().setType("S").setChannel(Integer.toString(this.hidDevice.hashCode())).setData("Upgrade Start\r\n").setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextArea(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, 1, 53};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] moduleUpgrade2(int size) {
        String cmd = "AT+QFOTADL=\"COM:\"," + size + ",3000\r\n";
        OutputLog outputLog = new OutputLog().setType("S").setChannel(Integer.toString(this.hidDevice.hashCode())).setData(cmd).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextArea(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, 0, 84};
        bodyData = ArrayUtils.addAll((byte[])bodyData, (byte[])cmd.getBytes());
        CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        byte[] cmdData = MainPane.protocol.getByteData(cmd_head, bodyData);
        return cmdData;
    }

    public byte[] moduleUpgrade3(byte[] data) {
        byte[] bodyData = new byte[]{6, 0, 84};
        bodyData = ArrayUtils.addAll((byte[])bodyData, (byte[])data);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        byte[] cmdData = MainPane.protocol.getByteData(cmd_head, bodyData);
        return cmdData;
    }

    public byte[] moduleUpgrade4() {
        String cmd = "AT+QFOTADL=1\r\n";
        OutputLog outputLog = new OutputLog().setType("S").setChannel(Integer.toString(this.hidDevice.hashCode())).setData(cmd).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextArea(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, 0, 84};
        bodyData = ArrayUtils.addAll((byte[])bodyData, (byte[])cmd.getBytes());
        CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        byte[] cmdData = MainPane.protocol.getByteData(cmd_head, bodyData);
        return cmdData;
    }

    public byte[] moduleUpgrade5() {
        OutputLog outputLog = new OutputLog().setType("S").setChannel(Integer.toString(this.hidDevice.hashCode())).setData("Upgrade Finished\r\n").setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextArea(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{4, 2, 28, -128};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }
}

