/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ResourceManager {
    private final Logger log = Logger.getLogger(ResourceManager.class.getName());
    private final Class<?> demoClass;
    private final ResourceBundle bundle = null;

    public ResourceManager(Class<?> demoClass) {
        this.demoClass = demoClass;
    }

    public String getString(String key) {
        return this.bundle != null ? this.bundle.getString(key) : key;
    }

    public ImageIcon createImageIcon(String filename) {
        try {
            String path = "/resources/images/" + filename;
            URL imageURL = this.demoClass.getResource(path);
            if (imageURL == null) {
                this.log.log(Level.SEVERE, "unable to access image file: " + path);
                return null;
            }
            return new ImageIcon(imageURL);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ImageIcon getImageIcon(String path) {
        return new ImageIcon(path);
    }
}

