/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.bluetooth;

import com.alibaba.fastjson.JSONObject;
import com.eview.serial.SerialPortsService;
import com.eview.tool.MainPane;
import com.eview.tool.bluetooth.BlueCellRender;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BlueSerialJDialog
extends JDialog
implements ActionListener {
    public static final int CMD_Request = 240;
    public static final int CMD_FilterConfig = 243;
    public static final int CMD_BleControl = 244;
    public static final int CMD_Notification = 245;
    public static final int Request_USBMAC = 1;
    public static final int BLE_Disconnect = 1;
    public static final int BLE_Connect = 2;
    public static final int BLE_ScanStart = 3;
    public static final int BLE_ScanStop = 4;
    public static final int BLE_Query = 5;
    public static final int ADV_Subcribing = 1;
    private final JPanel bluetoothPanel = new JPanel();
    private final JList<Map<String, Object>> blueList;
    private final BlueListModel listModel;
    private JScrollPane scrollPane = null;
    private final JButton scan = new JButton("Scan");
    private final JButton stop = new JButton("Stop scanning");
    private final JButton connect = new JButton("Connect");
    private final JButton disconnect = new JButton("Disconnect");
    private final PlaceholderTextField input_rssi = new PlaceholderTextField("-60");
    private final PlaceholderTextField input_name = new PlaceholderTextField();
    private final JPanel statusJPanel = new JPanel();
    private final JLabel lab_usbmac = new JLabel();
    private final JLabel lab_bltmac = new JLabel();
    private final int jdialogWidth = 540;
    private final int jdialogHeight = 460;
    private boolean selectedConnect = false;
    private static BlueSerialJDialog instance = new BlueSerialJDialog();

    public static BlueSerialJDialog getInstance() {
        return instance;
    }

    private BlueSerialJDialog() {
        this.setTitle("Bluetooth Serial");
        this.setResizable(false);
        this.bluetoothPanel.setLayout(null);
        Container desktopPane = this.getContentPane();
        this.bluetoothPanel.add((Component)desktopPane, "Center");
        this.setContentPane(this.bluetoothPanel);
        this.setBounds(new Rectangle(0, 0, 540, 460));
        this.setLocationRelativeTo(null);
        this.scan.setBounds(new Rectangle(5, 10, 70, 30));
        this.bluetoothPanel.add(this.scan);
        this.scan.addActionListener(this);
        this.stop.setBounds(new Rectangle(80, 10, 125, 30));
        this.bluetoothPanel.add(this.stop);
        this.stop.addActionListener(this);
        this.connect.setBounds(new Rectangle(210, 10, 90, 30));
        this.bluetoothPanel.add(this.connect);
        this.connect.addActionListener(this);
        this.disconnect.setBounds(new Rectangle(305, 10, 110, 30));
        this.bluetoothPanel.add(this.disconnect);
        this.disconnect.addActionListener(this);
        this.input_rssi.setBounds(new Rectangle(420, 10, 50, 30));
        this.input_rssi.setPlaceholder("Rssi");
        this.bluetoothPanel.add(this.input_rssi);
        this.input_name.setBounds(new Rectangle(475, 10, 50, 30));
        this.input_name.setPlaceholder("Name");
        this.bluetoothPanel.add(this.input_name);
        int rssi = Integer.parseInt(this.input_rssi.getText());
        String name = this.input_name.getText();
        this.listModel = new BlueListModel(rssi, name);
        this.blueList = new JList(this.listModel);
        this.blueList.setSelectionMode(0);
        this.scrollPane = PanelUtil.createScrollPanel(this.blueList, 5, 50, 520, 330);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.bluetoothPanel.add((Component)this.scrollPane, "Center");
        this.statusJPanel.setLayout(null);
        this.statusJPanel.setBounds(new Rectangle(0, 390, 540, 35));
        this.statusJPanel.setBorder(BorderFactory.createLineBorder(Constants.background));
        this.statusJPanel.setBackground(Constants.background);
        this.lab_usbmac.setBounds(new Rectangle(5, 0, 260, 35));
        this.statusJPanel.add(this.lab_usbmac);
        this.lab_bltmac.setBounds(new Rectangle(250, 0, 260, 35));
        this.statusJPanel.add(this.lab_bltmac);
        this.bluetoothPanel.add(this.statusJPanel);
    }

    public void listenReceiveData(JSONObject data_json) {
        byte[] scanData = BytesHexStrUtil.hexStringToBytes((String)data_json.getString("originalData"));
        if (scanData.length > 8 && (scanData[8] & 0xFF) >= 240 && (scanData[8] & 0xFF) <= 245) {
            this.receiveData(scanData);
        }
    }

    public void initBlueJDialog() {
        this.lab_usbmac.setText("");
        this.lab_bltmac.setText("");
        this.listModel.clear();
        this.blueList.setModel(this.listModel);
        this.getUsbmac();
        this.bleQuery();
    }

    public void getUsbmac() {
        boolean isOpenPort = SerialPortsService.getInstance().getIsOpenPort();
        if (isOpenPort) {
            byte[] bodyData = new byte[]{-16, 1, 1};
            CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
            byte[] cmdData = MainPane.protocol.getByteData(cmd_head, bodyData);
            MainPane.sendData(cmdData);
        }
    }

    public static String returnMAC(byte[] data) {
        String mac = BytesHexStrUtil.bytesToHexString((byte[])data);
        if (mac != null) {
            return mac.replace(" ", ":");
        }
        return mac;
    }

    public static byte[] bleDisconnect(int sequenceId) {
        byte[] bodyData = new byte[]{-12, 1, 1};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] bleConnect(int sequenceId, byte[] mac) {
        byte[] cmd = new byte[]{-12, 9, 2, 0, 0};
        byte[] bodyData = ArrayUtils.addAll((byte[])cmd, (byte[])mac);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] bleScanStart(int sequenceId) {
        byte[] bodyData = new byte[]{-12, 1, 3};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] bleScanStop(int sequenceId) {
        byte[] bodyData = new byte[]{-12, 1, 4};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public void bleQuery() {
        boolean isOpenPort = SerialPortsService.getInstance().getIsOpenPort();
        if (isOpenPort) {
            byte[] bodyData = new byte[]{-12, 1, 5};
            CmdHead cmd_head = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
            byte[] cmdData = MainPane.protocol.getByteData(cmd_head, bodyData);
            MainPane.sendData(cmdData);
        }
    }

    public static byte[] advSubcribing(int sequenceId, boolean sub) {
        byte subcribing = 1;
        byte unsubcribing = 0;
        byte enable = sub ? subcribing : unsubcribing;
        byte[] bodyData = new byte[]{-11, 2, 1, enable};
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static String getMAC(byte[] data) {
        String mac = BytesHexStrUtil.bytesToHexString((byte[])data, (boolean)false);
        mac = mac.replace(" ", ":");
        return mac;
    }

    public void receiveData(byte[] data) {
        byte[] headData = Arrays.copyOfRange(data, 0, 8);
        byte[] bodyData = Arrays.copyOfRange(data, 8, data.length);
        if (bodyData.length > 2) {
            int cmd = bodyData[0] & 0xFF;
            int length = bodyData[1] & 0xFF;
            int key = bodyData[2] & 0xFF;
            byte[] values = Arrays.copyOfRange(bodyData, 3, bodyData.length);
            switch (cmd) {
                case 240: {
                    String usbmac = BlueSerialJDialog.returnMAC(Arrays.copyOfRange(bodyData, 3, bodyData.length));
                    this.lab_usbmac.setText("USB:[" + usbmac + "]");
                    break;
                }
                case 243: {
                    break;
                }
                case 244: {
                    if (bodyData.length == 3) {
                        int state = bodyData[2] & 0xFF;
                        if ((state & 1) == 1) {
                            this.lab_bltmac.setText("Bluetooth:[No connected]");
                        }
                        if ((state >> 1 & 1) == 1) {
                            this.lab_bltmac.setText("Bluetooth:[Connecting]");
                        }
                        if ((state >> 4 & 1) != 1) break;
                        this.lab_bltmac.setText("Bluetooth:[Connected]");
                        break;
                    }
                    if (bodyData.length <= 3) break;
                    int state = bodyData[3] & 0xFF;
                    if ((state & 1) == 1) {
                        this.lab_bltmac.setText("Bluetooth:[No connected]");
                    }
                    if ((state >> 1 & 1) == 1) {
                        this.lab_bltmac.setText("Bluetooth:[Connecting]");
                    }
                    if ((state >> 4 & 1) == 1) {
                        this.lab_bltmac.setText("Bluetooth:[Connected]");
                    }
                    byte[] bltmacByte = Arrays.copyOfRange(bodyData, 4, bodyData.length);
                    String bltmac = BytesHexStrUtil.bytesToHexString((byte[])bltmacByte, (boolean)false);
                    if ((state >> 5 & 1) != 1) break;
                    this.lab_bltmac.setText("Bluetooth:[" + bltmac + "]");
                    if (!this.selectedConnect) break;
                    this.selectedConnect = false;
                    this.setVisible(false);
                    break;
                }
                case 245: {
                    int avd_length;
                    if (key != 1) break;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    int key_1 = values[0] & 0xFF;
                    String mac = BlueSerialJDialog.getMAC(Arrays.copyOfRange(values, 1, 7));
                    map.put("mac", mac);
                    byte rssi = values[7];
                    int flag = values[8] & 0xFF;
                    int sr = flag & 1;
                    int type = flag >> 1 & 3;
                    int len = flag >> 3 & 0xF;
                    map.put("rssi", "" + rssi);
                    int key_2 = values[9] & 0xFF;
                    Arrays.copyOfRange(values, 9, 12);
                    byte[] avd = Arrays.copyOfRange(values, 12, values.length);
                    for (int i = 0; i < avd.length; i += avd_length + 1) {
                        avd_length = avd[i] & 0xFF;
                        int avd_key = avd[i + 1] & 0xFF;
                        byte[] avd_data = Arrays.copyOfRange(avd, i + 2, i + 1 + avd_length);
                        if (avd_key == 8 || avd_key == 9) {
                            String avd_name = BytesHexStrUtil.bytes2StringByASCII((byte[])avd_data);
                            map.put("name", avd_name);
                            continue;
                        }
                        if (avd_key != 255 || avd_data.length < 11) continue;
                        int companyId = avd_data[0] & 0xFF | (avd_data[1] & 0xFF) << 8;
                        int verion = avd_data[2] & 0xFF;
                        int avd_moduleId = avd_data[3] & 0xFF | (avd_data[4] & 0xFF) << 8 | (avd_data[5] & 0xFF) << 16 | (avd_data[6] & 0xFF) << 24;
                        int avd_battery = avd_data[7] & 0xFF;
                        int avd_state = avd_data[8] & 0xFF | (avd_data[9] & 0xFF) << 8;
                        int avd_crc = avd_data[10] & 0xFF | (avd_data[11] & 0xFF) << 8;
                        map.put("battery", "" + avd_battery);
                        map.put("moduleId", Integer.toHexString(avd_moduleId));
                        map.put("state", Integer.toHexString(avd_state));
                    }
                    this.listModel.addElement(map);
                    break;
                }
                default: {
                    System.out.println("\u534f\u8bae\u4e0d\u652f\u6301...");
                }
            }
        }
    }

    public void bleScan() {
        byte[] cmdData3 = BlueSerialJDialog.bleScanStart(++MainPane.sequenceId);
        MainPane.sendData(cmdData3);
        byte[] cmdData4 = BlueSerialJDialog.advSubcribing(++MainPane.sequenceId, true);
        MainPane.sendData(cmdData4);
    }

    public void bleStopScan() {
        byte[] cmdData = BlueSerialJDialog.advSubcribing(++MainPane.sequenceId, false);
        MainPane.sendData(cmdData);
        byte[] cmdData2 = BlueSerialJDialog.bleScanStop(++MainPane.sequenceId);
        MainPane.sendData(cmdData2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index;
        if (e.getSource().equals(this.scan)) {
            this.listModel.clear();
            this.listModel.setRssi(Convert.toInt((Object)this.input_rssi.getText(), (Integer)0));
            this.listModel.setName(this.input_name.getText());
            this.bleScan();
        }
        if (e.getSource().equals(this.stop)) {
            this.bleStopScan();
        }
        if (e.getSource().equals(this.connect) && (index = this.blueList.getSelectedIndex()) >= 0) {
            Map map = this.listModel.getElementAt(index);
            String mac = map.get("mac").toString().replaceAll(":", "");
            byte[] macBytes = BytesHexStrUtil.hexStringToBytes((String)mac, (boolean)false);
            byte[] cmdData = BlueSerialJDialog.bleConnect(++MainPane.sequenceId, macBytes);
            MainPane.sendData(cmdData);
            this.selectedConnect = true;
            this.bleQuery();
        }
        if (e.getSource().equals(this.disconnect)) {
            byte[] cmdData = BlueSerialJDialog.bleDisconnect(++MainPane.sequenceId);
            MainPane.sendData(cmdData);
            this.lab_bltmac.setText("");
        }
    }

    class BlueListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private int rssi;
        private String name;
        private final List<String> keyList = new ArrayList<String>();
        private final Map<String, Map> mapBuffer = new HashMap<String, Map>();

        public BlueListModel(int rssi, String name) {
            this.rssi = rssi;
            this.name = name;
        }

        public void setRssi(int rssi) {
            this.rssi = rssi;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void clear() {
            this.keyList.clear();
            this.mapBuffer.clear();
            BlueSerialJDialog.this.blueList.repaint();
            BlueSerialJDialog.this.scrollPane.repaint();
        }

        public void addElement(Map map) {
            String key = (String)map.get("mac");
            int thisRssi = Convert.toInt(map.get("rssi"), (Integer)0);
            String thisName = Convert.toStr(map.get("name"), (String)"");
            if (thisName.contains("EV04")) {
                key = (String)map.get("name");
            }
            if (thisRssi > this.rssi && thisName.toLowerCase().contains(this.name.toLowerCase())) {
                if (!this.mapBuffer.containsKey(key)) {
                    this.keyList.add(key);
                    BlueSerialJDialog.this.blueList.paintImmediately(BlueSerialJDialog.this.blueList.getBounds());
                }
                this.mapBuffer.put(key, map);
                BlueSerialJDialog.this.blueList.setCellRenderer(new BlueCellRender());
                BlueSerialJDialog.this.blueList.repaint();
                BlueSerialJDialog.this.scrollPane.repaint();
            }
        }

        @Override
        public Map getElementAt(int index) {
            if (this.keyList.size() > index) {
                String key = this.keyList.get(index);
                return this.mapBuffer.get(key);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.keyList.size();
        }
    }
}

