/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.customUI;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JHyperlink
extends JButton {
    private boolean visited = true;
    private Color normalForeground;
    private Color activeForeground;
    private Color visitedForeground;
    private boolean drawUnderline = true;
    private final transient Rectangle viewRect = new Rectangle();
    private final transient Rectangle iconRect = new Rectangle();
    private final transient Rectangle textRect = new Rectangle();

    public JHyperlink() {
        this.normalForeground = UIManager.getColor("Hyperlink.foreground");
        this.activeForeground = UIManager.getColor("Hyperlink.activeForeground");
        this.visitedForeground = UIManager.getColor("Hyperlink.visitedForeground");
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setHorizontalAlignment(2);
        this.setForeground(this.normalForeground);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(null);
    }

    public JHyperlink(String text) {
        this();
        this.setText(text);
    }

    @Override
    public void setForeground(Color foreground) {
        this.normalForeground = foreground;
        super.setForeground(foreground);
    }

    @Override
    protected void paintComponent(Graphics g) {
        ButtonModel model = this.getModel();
        if (model.isArmed()) {
            super.setForeground(this.activeForeground);
        } else if (this.visited) {
            super.setForeground(this.visitedForeground);
        } else {
            super.setForeground(this.normalForeground);
        }
        super.paintComponent(g);
        if (this.drawUnderline) {
            Insets insets = this.getInsets();
            this.viewRect.x = insets.left;
            this.viewRect.y = insets.top;
            this.viewRect.width = this.getWidth() - insets.left - insets.right;
            this.viewRect.height = this.getHeight() - insets.top - insets.bottom;
            int baseline = this.getBaseline(this.viewRect.width, this.viewRect.height);
            this.iconRect.height = 0;
            this.iconRect.width = 0;
            this.iconRect.y = 0;
            this.iconRect.x = 0;
            this.textRect.height = 0;
            this.textRect.width = 0;
            this.textRect.y = 0;
            this.textRect.x = 0;
            SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.getIconTextGap());
            baseline = UIManager.getLookAndFeel().getName().equals("Nimbus") ? (baseline += 7) : (baseline += 3);
            g.setColor(this.getForeground());
            g.drawLine(this.textRect.x, baseline, this.textRect.x + this.textRect.width, baseline);
        }
    }

    static {
        UIManager.put("Hyperlink.foreground", Color.blue);
        UIManager.put("Hyperlink.activeForeground", Color.red);
        UIManager.put("Hyperlink.visitedForeground", new Color(9, 163, 200));
    }
}

