/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.customUI;

import com.tracker.ev07b.ProtocolUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MultiComboBox
extends JComboBox
implements ActionListener {
    public MultiComboBox(String ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.addItem(new CheckValue(false, values[i].replaceAll("[a-zA-Z]", ""), values[i]));
        }
        this.init();
    }

    public MultiComboBox(String[][] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addItem(new CheckValue(false, values[i][0], values[i][1]));
        }
        this.init();
    }

    private void init() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MultiComboBox.this.itemSelected();
            }
        });
        this.setRenderer(new RwJCheckBox());
        this.setSelectedIndex(-1);
    }

    private void itemSelected() {
        if (this.getSelectedItem() instanceof JCheckBox) {
            if (this.getSelectedIndex() == 0) {
                this.selectedAllItem();
            } else {
                JCheckBox jcb;
                jcb.setSelected(!(jcb = (JCheckBox)this.getSelectedItem()).isSelected());
                this.setSelectedIndex(this.getSelectedIndex());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiComboBox.this.showPopup();
                }
            });
        }
        if (this.getSelectedItem() instanceof CheckValue) {
            CheckValue ckValue = (CheckValue)this.getSelectedItem();
            ckValue.check = !ckValue.check;
            this.setSelectedIndex(this.getSelectedIndex());
        }
        if (this.getSelectedItem() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiComboBox.this.showPopup();
                }
            });
        }
    }

    private void selectedAllItem() {
        boolean bl = false;
        for (int i = 0; i < this.getItemCount(); ++i) {
            JCheckBox jcb = (JCheckBox)this.getItemAt(i);
            if (i == 0) {
                bl = !jcb.isSelected();
            }
            jcb.setSelected(bl);
        }
        this.setSelectedIndex(0);
    }

    public long getComboVc() {
        int flag = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            CheckValue ckValue = (CheckValue)this.getItemAt(i);
            if (!ckValue.check) continue;
            flag += 1 << Integer.parseInt(ckValue.index);
        }
        return flag;
    }

    public void setComboVc(long flag) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            CheckValue ckValue = (CheckValue)this.getItemAt(i);
            int index = Integer.parseInt(ckValue.index);
            ckValue.check = ProtocolUtil.getbit((long)flag, (int)index, (int)(index + 1)) == 1;
        }
        this.setSelectedIndex(-1);
    }

    public class CheckValue {
        public boolean check = false;
        public String index = null;
        public String value = null;

        public CheckValue() {
        }

        public CheckValue(boolean check, String index, String value) {
            this.check = check;
            this.index = index;
            this.value = value;
        }
    }

    public static class RwJCheckBox
    extends JCheckBox
    implements ListCellRenderer {
        protected static Border noFocusBorder;

        public RwJCheckBox() {
            if (noFocusBorder == null) {
                noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            }
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object ckValue;
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof CheckValue) {
                ckValue = (CheckValue)value;
                this.setText(((CheckValue)ckValue).value == null ? "" : ((CheckValue)ckValue).value);
                this.setSelected(((CheckValue)ckValue).check);
            }
            if (value instanceof JCheckBox) {
                ckValue = (JCheckBox)value;
                this.setText(((AbstractButton)ckValue).getText() == null ? "" : ((AbstractButton)ckValue).getText());
                this.setSelected(((AbstractButton)ckValue).isSelected());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }
}

