/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.handler.HandlerChain;
import com.eview.tool.handler.IHandler;
import com.eview.util.Constants;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HandlerListMap
implements IHandler {
    public static final String LIST = "$";
    public static final String CHILD = "_";

    @Override
    public void handleRequest(HandlerChain chain) {
        this.doJson2Map(chain.getData());
        chain.handleRequest();
    }

    @Override
    public void handleResponse(HandlerChain chain) {
        this.doMap2Json(chain.getData());
        chain.handleResponse();
    }

    private void doJson2Map(JSONObject configData) {
        JSONObject configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!(configData_copy.get((Object)key) instanceof List)) continue;
            JSONArray list = configData_copy.getJSONArray(key);
            for (int i = 0; i < list.size(); ++i) {
                int index = list.getJSONObject(i).getIntValue("index");
                configData.put(key + LIST + index, (Object)list.getJSONObject(i));
            }
            configData.remove((Object)key);
        }
        configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!(configData_copy.get((Object)key) instanceof Map)) continue;
            JSONObject object = configData_copy.getJSONObject(key);
            for (String key2 : object.keySet()) {
                configData.put(key + CHILD + key2, object.get((Object)key2));
            }
            configData.remove((Object)key);
        }
        configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (key.contains("latlng")) {
                configData.put(key, (Object)configData_copy.getJSONArray(key).toJSONString());
                continue;
            }
            if (key.equals("dateTime")) {
                Date dateTime = configData_copy.getDate(key);
                configData.put("dateTime", (Object)Constants.dateTimeFormat.format(dateTime));
                int runTime = configData_copy.getIntValue("runTime");
                Date startTime = new Date(dateTime.getTime() - (long)(runTime * 1000));
                configData.put("startTime", (Object)Constants.dateTimeFormat.format(startTime));
                continue;
            }
            if (key.contains("birthday")) {
                Date birthday = configData_copy.getDate(key);
                configData.put(key, (Object)Constants.dateFormat.format(birthday));
                continue;
            }
            if (!key.contains("bloodType")) continue;
            int bloodType = configData_copy.getIntValue(key);
            if (bloodType > 3) {
                bloodType -= 12;
            }
            configData.put(key, (Object)bloodType);
        }
    }

    private void doMap2Json(JSONObject configData) {
        JSONObject configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!key.contains(CHILD)) continue;
            String[] keys = key.split(CHILD);
            JSONObject obj = null;
            obj = configData.get((Object)keys[0]) == null ? new JSONObject() : configData.getJSONObject(keys[0]);
            obj.put(keys[1], configData_copy.get((Object)key));
            configData.put(keys[0], (Object)obj);
            configData.remove((Object)key);
        }
        configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!key.contains(LIST)) continue;
            String key1 = key.replace(LIST, "");
            String index = key1.replaceAll("[a-zA-Z]", "");
            JSONObject obj = configData_copy.getJSONObject(key);
            obj.put("index", (Object)Integer.parseInt(index));
            configData.remove((Object)key);
            String key2 = key1.replaceAll("[\\d]", "");
            if (configData.get((Object)key2) != null) {
                configData.getJSONArray(key2).add((Object)obj);
                continue;
            }
            JSONArray list = new JSONArray();
            list.add((Object)obj);
            configData.put(key2, (Object)list);
        }
    }
}

