/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.html;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.html.JsCallback;
import com.eview.tool.model.PanelUtil;
import com.eview.util.FileUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GeoMap {
    private static final Logger log = Logger.getLogger(GeoMap.class);
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 460;
    private static JSONObject paneAlert;
    private static int index;
    private Map<String, Object> geofenceData;
    private static GeoMap instance;
    private Display display;
    private Shell shell;

    public static GeoMap getInstance() {
        return instance;
    }

    private GeoMap() {
    }

    public void show(JSONObject paneAlert, int index) {
        Browser browser;
        GeoMap.paneAlert = paneAlert;
        GeoMap.index = index;
        this.geofenceData = this.getGeofenceRange();
        this.display = new Display();
        this.shell = new Shell(this.display, 51296);
        this.shell.setText("Geofence Map");
        this.shell.setSize(800, 460);
        this.shell.setLayout((Layout)new FillLayout());
        PanelUtil.setCenter(this.shell);
        try {
            browser = new Browser((Composite)this.shell, 262144);
        }
        catch (SWTError e) {
            System.out.println("Could not instantiate Browser: " + e.getMessage());
            this.display.dispose();
            return;
        }
        browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String type = this.geofenceData.get("type").toString();
            String radius = this.geofenceData.get("radius").toString();
            String latLng = this.geofenceData.get("latlng").toString();
            browser.execute("setGeofenceData('" + type + "','" + radius + "','" + latLng + "')");
            new JsCallback(browser, "saveGeofenceData", arguments -> {
                String data = Convert.toStr((Object)arguments[0]);
                if (!data.isEmpty()) {
                    JSONObject geo_data = JSON.parseObject((String)data);
                    this.setGeofenceRange((Map<String, Object>)geo_data);
                }
                return null;
            });
        }));
        String htmlPath = FileUtil.getCurrentPath("./html/map/maps_geofence.html");
        browser.setUrl("file:///" + htmlPath);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public Map<String, Object> getGeofenceRange() {
        HashMap<String, Object> geo_data = new HashMap<String, Object>();
        String geoAlertKey = "geoAlert$" + index;
        JComboBox geo_type = (JComboBox)paneAlert.get((Object)(geoAlertKey + "_type"));
        JTextField geo_radius = (JTextField)paneAlert.get((Object)(geoAlertKey + "_radius"));
        JTextField geo_latlng = (JTextField)paneAlert.get((Object)(geoAlertKey + "_latlng"));
        String type = geo_type.getSelectedItem().toString();
        String radius = geo_radius.getText();
        String latlng = geo_latlng.getText();
        geo_data.put("type", type);
        geo_data.put("radius", radius);
        geo_data.put("latlng", latlng);
        return geo_data;
    }

    public void setGeofenceRange(Map<String, Object> geofenceData) {
        String geoAlertKey = "geoAlert$" + index;
        JComboBox geo_type = (JComboBox)paneAlert.get((Object)(geoAlertKey + "_type"));
        JTextField geo_radius = (JTextField)paneAlert.get((Object)(geoAlertKey + "_radius"));
        JTextField geo_latlng = (JTextField)paneAlert.get((Object)(geoAlertKey + "_latlng"));
        geo_type.setSelectedItem(geofenceData.get("type"));
        if (geofenceData.get("radius") != null) {
            geo_radius.setText(geofenceData.get("radius").toString());
        }
        geo_latlng.setText(geofenceData.get("latlng").toString());
    }

    static {
        instance = new GeoMap();
    }
}

