/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.CheckDocument;
import com.eview.tool.MainPane;
import com.eview.tool.MessageDialog;
import com.eview.tool.PasswordJDialog;
import com.eview.tool.customUI.MultiComboBox;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.customUI.TabbedPaneUI;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;

public class PanelUtil {
    private static final Logger log = Logger.getLogger(PanelUtil.class);

    private PanelUtil() {
    }

    public static JTabbedPane createTabbedPane(LayoutManager layout) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        tabbedPane.setPreferredSize(new Dimension(945, 574));
        FlowLayout f = (FlowLayout)layout;
        f.setHgap(0);
        f.setVgap(0);
        tabbedPane.setUI(new TabbedPaneUI(172, 56));
        tabbedPane.setBackground(Constants.background);
        tabbedPane.setTabPlacement(2);
        return tabbedPane;
    }

    public static void setTabbedPaneScroll(JTabbedPane tabbedPane) {
        tabbedPane.setTabLayoutPolicy(1);
        tabbedPane.addMouseWheelListener(e -> {
            if (e.getX() < 175) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                int units = e.getWheelRotation();
                int oldIndex = pane.getSelectedIndex();
                int newIndex = oldIndex + units;
                if (newIndex < 0) {
                    pane.setSelectedIndex(0);
                } else if (newIndex >= pane.getTabCount()) {
                    pane.setSelectedIndex(pane.getTabCount() - 1);
                } else {
                    pane.setSelectedIndex(newIndex);
                }
            }
        });
    }

    public static JLabel createLabel(String title, int x, int y, int width, int height) {
        JLabel lab = new JLabel(title);
        lab.setBounds(new Rectangle(x, y, width, height));
        return lab;
    }

    public static JButton createButton(String title, int x, int y, int width, int height) {
        JButton button = new JButton(title);
        button.setBounds(new Rectangle(x, y, width, height));
        return button;
    }

    public static JToggleButton createToggleButton(int x, int y, int width, int height) {
        JToggleButton button = new JToggleButton();
        button.setBounds(new Rectangle(x, y, width, height));
        return button;
    }

    public static JCheckBox createCheckBox(String title, int x, int y, int width, int height) {
        JCheckBox cbox = new JCheckBox(title);
        cbox.setBounds(new Rectangle(x, y, width, height));
        return cbox;
    }

    public static JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        return panel;
    }

    public static JPanel createPanel(int width, int height) {
        JPanel panel = PanelUtil.createPanel();
        panel.setPreferredSize(new Dimension(width, height));
        return panel;
    }

    public static JPanel createPanel(String title, int x, int y, int width, int height) {
        JPanel panel = PanelUtil.createPanel();
        panel.setBounds(x, y, width, height);
        PanelUtil.showTitle(panel, title);
        return panel;
    }

    public static void showTitle(JComponent panel, String title) {
        panel.setBorder(BorderFactory.createTitledBorder(title));
    }

    public static JScrollPane createScrollPanel(JComponent panel, int x, int y, int width, int height) {
        JScrollPane scrollPanel = PanelUtil.createScrollPanel(panel);
        scrollPanel.setBounds(new Rectangle(x, y, width, height));
        return scrollPanel;
    }

    public static JScrollPane createScrollPanel(JComponent panel, int width, int height) {
        JScrollPane scrollPanel = PanelUtil.createScrollPanel(panel);
        scrollPanel.setPreferredSize(new Dimension(width, height));
        return scrollPanel;
    }

    public static JScrollPane createScrollPanel(JComponent panel) {
        JScrollPane scrollPanel = new JScrollPane(panel);
        scrollPanel.setVerticalScrollBarPolicy(20);
        scrollPanel.getVerticalScrollBar().setUnitIncrement(10);
        return scrollPanel;
    }

    public static void checkInput(JTextField input, String regex, JSONArray jsonArray) {
        input.getDocument().addDocumentListener(new CheckDocument(text -> {
            if (Pattern.matches(regex, text)) {
                input.setForeground(Color.BLACK);
                if (jsonArray.contains((Object)input)) {
                    jsonArray.remove((Object)input);
                }
            } else {
                input.setForeground(Color.RED);
                if (!jsonArray.contains((Object)input)) {
                    jsonArray.add((Object)input);
                }
            }
        }));
    }

    public static void checkInput(JTextField input, String regex, JCheckBox cbox, JSONArray jsonArray) {
        input.getDocument().addDocumentListener(new CheckDocument(text -> {
            if (Pattern.matches(regex, text)) {
                input.setForeground(Color.BLACK);
                if (jsonArray.contains((Object)input)) {
                    jsonArray.remove((Object)input);
                }
            } else {
                input.setForeground(Color.RED);
                if (!jsonArray.contains((Object)input)) {
                    jsonArray.add((Object)input);
                }
            }
            if (text.equals("911")) {
                cbox.setEnabled(false);
                cbox.setSelected(false);
            } else {
                cbox.setEnabled(true);
            }
        }));
    }

    public static boolean checkError(JSONObject paneObjectAll, JSONObject ... paneObject) {
        AtomicInteger sum = new AtomicInteger(0);
        Arrays.stream(paneObject).forEach(paneObj -> {
            JSONArray array = paneObjectAll.getJSONArray(paneObj.getString("check"));
            boolean checked = Optional.ofNullable(array).map(list -> list.stream().filter(input -> ((JTextField)input).isVisible()).filter(input -> !StrUtil.isBlank((CharSequence)((JTextField)input).getText())).collect(Collectors.toCollection(JSONArray::new))).filter(list -> list.size() > 0).isPresent();
            if (checked) {
                log.info((Object)("CheckError:" + array.size()));
                sum.addAndGet(array.size());
            }
        });
        if (sum.get() > 0) {
            MessageDialog.show(MainPane.getThisModel(), "You have " + sum.get() + " errors, please check", 2000L);
        }
        return sum.get() > 0;
    }

    public static JSONArray setCheck(JPanel panel, JSONObject paneObjectAll, JSONObject panelObject) {
        panelObject.put("check", (Object)panel.hashCode());
        JSONArray checkArray = new JSONArray();
        paneObjectAll.put("" + panel.hashCode(), (Object)checkArray);
        return checkArray;
    }

    public static void changeWorkMode(JSONObject paneSystems, JSONObject paneObjectAll, String[] infos) {
        JComboBox workMode = (JComboBox)paneSystems.get((Object)"workMode_mode");
        JTextField input_time = (JTextField)paneSystems.getObject("workMode_time", JTextField.class);
        JTextField input_upload = (JTextField)paneSystems.getObject("timeInterval_upload", JTextField.class);
        JTextField input_uploadLazy = (JTextField)paneSystems.getObject("timeInterval_uploadLazy", JTextField.class);
        JLabel lab_info = (JLabel)paneObjectAll.getObject("lab_infoTimeInterval", JLabel.class);
        JToggleButton btn_heartBeatStatus = (JToggleButton)paneSystems.get((Object)"timeInterval_heartBeatStatus");
        PlaceholderTextField input_heartBeat = (PlaceholderTextField)paneSystems.get((Object)"timeInterval_heartBeat");
        switch (workMode.getSelectedIndex()) {
            case 0: {
                input_time.setVisible(false);
                input_upload.setVisible(false);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[0]);
                btn_heartBeatStatus.setEnabled(true);
                input_heartBeat.setEnabled(true);
                break;
            }
            case 1: 
            case 5: {
                input_time.setVisible(false);
                input_upload.setVisible(true);
                input_uploadLazy.setVisible(true);
                lab_info.setText(infos[1]);
                btn_heartBeatStatus.setEnabled(true);
                input_heartBeat.setEnabled(true);
                break;
            }
            case 2: {
                input_time.setVisible(false);
                input_upload.setVisible(true);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[2]);
                btn_heartBeatStatus.setEnabled(true);
                input_heartBeat.setEnabled(true);
                break;
            }
            case 3: {
                input_time.setVisible(true);
                input_upload.setVisible(false);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[3]);
                btn_heartBeatStatus.setEnabled(false);
                input_heartBeat.setEnabled(false);
                break;
            }
            case 4: {
                input_time.setVisible(true);
                input_upload.setVisible(false);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[4]);
                btn_heartBeatStatus.setEnabled(false);
                input_heartBeat.setEnabled(false);
            }
        }
    }

    public static void showPasswordJDialog(int code) {
        if (code == 64 || code == 18) {
            if (!PasswordJDialog.getInstance().isVisible()) {
                PasswordJDialog.getInstance().setVisible(true);
            }
        } else if (PasswordJDialog.getInstance().isVisible()) {
            PasswordJDialog.getInstance().setVisible(false);
        }
    }

    public static void setCenter(Shell shell) {
        int width = shell.getMonitor().getClientArea().width;
        int height = shell.getMonitor().getClientArea().height;
        int x = shell.getSize().x;
        int y = shell.getSize().y;
        if (x > width) {
            shell.getSize().x = width;
        }
        if (y > height) {
            shell.getSize().y = height;
        }
        shell.setLocation((width - x) / 2, (height - y) / 2);
    }

    public static JSONObject getPanel(JSONObject paneObject) {
        JSONObject jsonData = new JSONObject();
        for (Map.Entry entry : paneObject.entrySet()) {
            JComboBox cbBox;
            String key = (String)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof JTextField) {
                JTextField input = (JTextField)object;
                if (key.contains("latlng")) {
                    jsonData.put(key, JSON.parse((String)input.getText()));
                    continue;
                }
                jsonData.put(key, (Object)input.getText());
                continue;
            }
            if (object instanceof ButtonGroup) {
                ButtonGroup group = (ButtonGroup)object;
                Enumeration<AbstractButton> e = group.getElements();
                while (e.hasMoreElements()) {
                    JRadioButton b = (JRadioButton)e.nextElement();
                    if (!b.getName().contains("_1")) continue;
                    jsonData.put(key, (Object)(b.isSelected() ? 1 : 0));
                }
                continue;
            }
            if (object instanceof JCheckBox) {
                JCheckBox chBox = (JCheckBox)object;
                jsonData.put(key, (Object)(chBox.isSelected() ? 1 : 0));
                continue;
            }
            if (object instanceof JToggleButton) {
                JToggleButton toggleBtn = (JToggleButton)object;
                jsonData.put(key, (Object)(toggleBtn.isSelected() ? 1 : 0));
                continue;
            }
            if (object instanceof MultiComboBox) {
                cbBox = (MultiComboBox)object;
                jsonData.put(key, (Object)((MultiComboBox)cbBox).getComboVc());
                continue;
            }
            if (!(object instanceof JComboBox)) continue;
            cbBox = (JComboBox)object;
            if (key.equals("timeZone")) {
                String timeZoneStr = Objects.requireNonNull(cbBox.getSelectedItem()).toString();
                float timeZone = PublicUtil.getTimeZoneToString(timeZoneStr);
                jsonData.put(key, (Object)Float.valueOf(timeZone));
                continue;
            }
            if (key.equals("personalInfo_bloodType")) {
                int bloodType = cbBox.getSelectedIndex();
                if (bloodType > 3) {
                    bloodType += 12;
                }
                jsonData.put(key, (Object)bloodType);
                continue;
            }
            if (key.equals("locale")) {
                jsonData.put(key, cbBox.getSelectedItem());
                continue;
            }
            jsonData.put(key, (Object)cbBox.getSelectedIndex());
        }
        return jsonData;
    }

    public static void showPaneData(JSONObject paneObject, JSONObject configData) {
        for (Map.Entry entry : paneObject.entrySet()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    Object data = configData.get(entry.getKey());
                    if (data != null) {
                        Object object = entry.getValue();
                        if (object instanceof JTextField) {
                            JTextField input = (JTextField)object;
                            input.setText(Convert.toStr((Object)data, (String)""));
                        } else if (object instanceof ButtonGroup) {
                            ButtonGroup group = (ButtonGroup)object;
                            int index = Convert.toInt((Object)data);
                            Enumeration<AbstractButton> e = group.getElements();
                            while (e.hasMoreElements()) {
                                JRadioButton b = (JRadioButton)e.nextElement();
                                if (b.getName().contains("_1") && index == 1) {
                                    b.setSelected(true);
                                    continue;
                                }
                                if (!b.getName().contains("_0") || index != 0) continue;
                                b.setSelected(true);
                            }
                        } else if (object instanceof JCheckBox) {
                            JCheckBox chbox = (JCheckBox)object;
                            int status = Convert.toInt((Object)data);
                            chbox.setSelected(status == 1);
                        } else if (object instanceof JToggleButton) {
                            JToggleButton toggleBtn = (JToggleButton)object;
                            int status = Convert.toInt((Object)data);
                            toggleBtn.setSelected(status == 1);
                        } else if (object instanceof MultiComboBox) {
                            MultiComboBox cbBox = (MultiComboBox)object;
                            cbBox.setComboVc(Convert.toLong((Object)data));
                        } else if (object instanceof JComboBox) {
                            JComboBox cbBox = (JComboBox)object;
                            if (((String)entry.getKey()).equals("timeZone")) {
                                float timeZone = Convert.toFloat((Object)data).floatValue();
                                String timeZoneStr = PublicUtil.getTimeZoneToString(timeZone);
                                cbBox.setSelectedItem(timeZoneStr);
                            } else if (((String)entry.getKey()).equals("locale")) {
                                String locale = Convert.toStr((Object)data);
                                cbBox.setSelectedItem(locale);
                            } else {
                                int index = Convert.toInt((Object)data) % cbBox.getItemCount();
                                cbBox.setSelectedIndex(index);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("key=" + (String)entry.getKey() + " value=" + String.valueOf(configData.get(entry.getKey()))), (Throwable)e);
                }
            });
        }
    }
}

