/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.netty;

import com.eview.tool.model.Model_Debug;
import com.eview.tool.netty.NettyClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NettyClient
extends Thread {
    private final Logger log = Logger.getLogger(NettyClient.class);
    private int port = 5050;
    private String host = "127.0.0.1";
    private static boolean isConnection = false;
    private EventLoopGroup workGroup = new NioEventLoopGroup();
    private ChannelFuture future;

    public NettyClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static boolean isConnection() {
        return isConnection;
    }

    @Override
    public void run() {
        try {
            Bootstrap b = new Bootstrap();
            b.group(this.workGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.TCP_NODELAY, (Object)true);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new NettyClientHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
                    ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                }
            });
            this.future = b.connect(this.host, this.port).sync();
            if (this.future.isSuccess()) {
                isConnection = true;
                Model_Debug.mock_socket_connection.setText("Disconnect");
                Model_Debug.mock_tcpType.setEnabled(false);
                Model_Debug.mock_host.setEnabled(false);
                Model_Debug.mock_port.setEnabled(false);
                this.log.debug((Object)("NettyClient Start successfully, host\uff1a" + this.host + "port\uff1a" + this.port));
            }
            this.future.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().close();
                    NettyClient.this.shutdown();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"NettyClient Exception:", (Throwable)e);
        }
    }

    public void sendData(byte[] data) {
        ByteBuf buffer = Unpooled.buffer((int)data.length);
        buffer.writeBytes(data);
        this.future.channel().writeAndFlush((Object)buffer);
    }

    public void shutdown() {
        isConnection = false;
        if (this.workGroup != null) {
            this.workGroup.shutdownGracefully();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Model_Debug.mock_socket_connection.setText("Connection");
                    Model_Debug.mock_tcpType.setEnabled(true);
                    Model_Debug.mock_host.setEnabled(true);
                    Model_Debug.mock_port.setEnabled(true);
                }
            });
            this.log.debug((Object)"NettyClient stoped.");
        }
    }
}

