/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.netty;

import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.RingBufferHigh;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

public class NettyClientHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = Logger.getLogger(NettyClientHandler.class);
    private RingBufferHigh bufferData = new RingBufferHigh();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf result = (ByteBuf)msg;
        try {
            byte[] con = new byte[result.readableBytes()];
            result.readBytes(con);
            this.bufferData.put(con);
        }
        finally {
            result.release();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.log.debug((Object)("channelReadComplete Size=" + this.bufferData.getSize() + " Capacity=" + this.bufferData.getCapacity()));
        if (this.bufferData.getSize() > 0) {
            OutputLog outputLog = new OutputLog().setIsLine(true).setIsShowTime(true).setTextArea(Model_Debug.mock_socket_outputArea);
            if (Model_Debug.mock_hexShow_receive.isSelected()) {
                outputLog.setData(BytesHexStrUtil.bytesToHexString((byte[])this.bufferData.getAll()));
            } else {
                outputLog.setData(new String(this.bufferData.getAll(), StandardCharsets.UTF_8));
            }
            OutputLogQueue.getInstance().addDebugLog(outputLog);
            ctx.flush();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        this.log.error((Object)("client " + String.valueOf(channel.remoteAddress()) + " Exception:"), cause);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        this.log.debug((Object)("client " + String.valueOf(channel.remoteAddress()) + " \u8fde\u63a5\u6210\u529f"));
    }
}

