/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.queue;

import com.eview.tool.queue.OutputLog;
import com.eview.util.Constants;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JTextArea;

public class OutputLogQueue
implements Runnable {
    private static final OutputLogQueue taskQueue = new OutputLogQueue();
    private final BlockingQueue<OutputLog> queue = new LinkedBlockingQueue<OutputLog>();

    private OutputLogQueue() {
    }

    public static OutputLogQueue getInstance() {
        return taskQueue;
    }

    public void addDebugLog(OutputLog task) {
        this.queue.add(task);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    OutputLog task = this.queue.take();
                    JTextArea textArea = task.getTextArea();
                    if (task.isLine() && textArea.getText().length() > 0) {
                        textArea.append(Constants.lines);
                    }
                    if (task.isShowTime()) {
                        textArea.append("[" + Constants.dateTimeFormat.format(new Date()) + "]");
                    }
                    if (task.getType() != null) {
                        textArea.append("[" + task.getType() + "]");
                    }
                    if (task.getChannel() != null) {
                        textArea.append("[" + task.getChannel() + "]");
                    }
                    if (task.getType() != null || task.getChannel() != null || task.isShowTime()) {
                        textArea.append(":");
                    }
                    textArea.append(task.getData());
                    textArea.setSelectionStart(textArea.getText().length());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

