/*
 * Decompiled with CFR 0.152.
 */
package com.eview.util;

import com.alibaba.fastjson.JSONObject;
import com.eview.tool.MainPane;
import com.eview.tool.customUI.MultiComboBox;
import com.eview.tool.html.GeoMap;
import com.eview.util.Constants;
import com.eview.util.FileUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.util.ArrayUtils;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.Logger;

public class PublicUtil {
    private static final Logger log = Logger.getLogger(PublicUtil.class);

    public static String getTimeZoneToString(float number) {
        if (number == 0.0f) {
            return "UTC 00:00";
        }
        DecimalFormat df = new DecimalFormat("UTC +00.00;UTC -00.00", new DecimalFormatSymbols(Locale.US));
        int minutes = (int)((number - (float)((int)number)) * 60.0f);
        String timeZoneStr = df.format(number).replaceAll("\\.\\d+", ":" + String.format("%02d", minutes));
        return timeZoneStr;
    }

    public static float getTimeZoneToString(String timeZoneStr) {
        String t = timeZoneStr.replace("UTC ", "").replace(":", ".");
        float timeZone = Float.parseFloat(t);
        float hours = (int)timeZone;
        float minutes = (timeZone - (float)((int)timeZone)) * 100.0f / 60.0f;
        return hours + minutes;
    }

    public static void readConfig(byte[] keys) {
        HashMap<String, byte[]> map_data = new HashMap<String, byte[]>(1);
        map_data.put("Read", keys);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_config(map_data);
        byte[] sendData = MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
        MainPane.sendData(sendData);
    }

    public static void savePanel(JSONObject configData) {
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_config((Map)configData);
        List byteData_body = MainPane.protocol.getByteData_body(cmd_bodyData, 900L);
        for (byte[] cmd_body : byteData_body) {
            CmdHead cmd_headData = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
            byte[] send_data = MainPane.protocol.getByteData(cmd_headData, cmd_body);
            MainPane.sendData(send_data);
            MainPane.delay(100L);
        }
    }

    public static void clearPanel(Map<String, Object> paneObject) {
        for (String key : paneObject.keySet()) {
            JComboBox cbBox;
            if (paneObject.get(key) instanceof JTextField) {
                JTextField input = (JTextField)paneObject.get(key);
                input.setText("");
                continue;
            }
            if (paneObject.get(key) instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)paneObject.get(key);
                bg.clearSelection();
                continue;
            }
            if (paneObject.get(key) instanceof JCheckBox) {
                JCheckBox chbox = (JCheckBox)paneObject.get(key);
                chbox.setSelected(false);
                continue;
            }
            if (paneObject.get(key) instanceof JToggleButton) {
                JToggleButton toggleBtn = (JToggleButton)paneObject.get(key);
                toggleBtn.setSelected(false);
                continue;
            }
            if (paneObject.get(key) instanceof MultiComboBox) {
                cbBox = (MultiComboBox)paneObject.get(key);
                ((MultiComboBox)cbBox).setComboVc(0L);
                continue;
            }
            if (paneObject.get(key) instanceof JComboBox) {
                cbBox = (JComboBox)paneObject.get(key);
                cbBox.setSelectedIndex(0);
                continue;
            }
            if (!(paneObject.get(key) instanceof JButton)) continue;
            String numberPhotoKey = "numberNamePhoto$";
            Object[] photos = new String[]{numberPhotoKey + "0_avatar", numberPhotoKey + "1_avatar", numberPhotoKey + "2_avatar", numberPhotoKey + "3_avatar", numberPhotoKey + "4_avatar", numberPhotoKey + "5_avatar", numberPhotoKey + "6_avatar", numberPhotoKey + "7_avatar", numberPhotoKey + "8_avatar", numberPhotoKey + "9_avatar", "personalInfo_avatar"};
            if (!ArrayUtils.contains((Object[])photos, (Object)key)) continue;
            JButton btn_avatar = (JButton)paneObject.get(key);
            String defaultIcon = FileUtil.getCurrentPath("./html/cropper/images/avatar.png");
            PublicUtil.resetImage(btn_avatar, defaultIcon);
            JTextField input_headURL = (JTextField)paneObject.get(key.replace("_avatar", "_headURL"));
            input_headURL.setName(defaultIcon);
            input_headURL.setText("");
        }
    }

    public static void resetImage(JButton button_avatar, String photoPath) {
        int iconWidth = button_avatar.getIcon().getIconWidth();
        int iconHeight = button_avatar.getIcon().getIconHeight();
        ImageIcon avatar = MainPane.resourceManager.getImageIcon(photoPath);
        Image image = avatar.getImage();
        image = image.getScaledInstance(iconWidth, iconHeight, 1);
        avatar.setImage(image);
        button_avatar.setIcon(avatar);
        button_avatar.setPressedIcon(avatar);
    }

    public static void changeGeoType(JSONObject paneAlert, int index) {
        String geoAlertKey = "geoAlert$" + index;
        JComboBox geoType3 = (JComboBox)paneAlert.get((Object)(geoAlertKey + "_type"));
        JTextField input = (JTextField)paneAlert.get((Object)(geoAlertKey + "_radius"));
        JTextField input2 = (JTextField)paneAlert.get((Object)(geoAlertKey + "_latlng"));
        if (geoType3.getSelectedIndex() == 0) {
            input.setVisible(true);
            input2.setVisible(true);
            input2.setBounds(new Rectangle(484, 12 + 47 * index, 218, 35));
        } else if (geoType3.getSelectedIndex() == 1) {
            input.setVisible(false);
            input2.setVisible(true);
            input2.setBounds(new Rectangle(404, 12 + 47 * index, 298, 35));
        }
    }

    public static void showGeoEditPage(JSONObject paneAlert, int index) {
        SwingUtilities.invokeLater(() -> GeoMap.getInstance().show(paneAlert, index));
    }

    public static JSONObject readProfile() {
        String filePath = Constants.configFileUtil.readProperty(MainPane.getThisModel().getKey(), "readProfile", ".");
        JFileChooser chooser = new JFileChooser(filePath);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.bin", "bin");
        chooser.setFileFilter(filter);
        chooser.setDialogTitle("Load Profile");
        int returnVal = chooser.showOpenDialog(MainPane.getThisModel());
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            Constants.configFileUtil.writeProperty(MainPane.getThisModel().getKey(), "readProfile", path);
            try {
                byte[] data = Files.readAllBytes(new File(path).toPath());
                Map mapData = (Map)MainPane.protocol.protocolAnalysis(data).get(0);
                JSONObject data_json = new JSONObject(mapData);
                JSONObject configData = data_json.getJSONObject("cmdBodyData").getJSONObject("configData");
                return configData;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void writeProfile(JSONObject dataAll) {
        String filePath = Constants.configFileUtil.readProperty(MainPane.getThisModel().getKey(), "writeProfile", ".");
        JFileChooser chooser = new JFileChooser(filePath);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.bin", "bin");
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File("config.bin"));
        int returnVal = chooser.showSaveDialog(MainPane.getThisModel());
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            Constants.configFileUtil.writeProperty(MainPane.getThisModel().getKey(), "writeProfile", path);
            CmdHead cmd_headData = MainPane.protocol.getCommandHead(++MainPane.sequenceId, true);
            CmdBody cmd_bodyData = MainPane.protocol.getCommand_config((Map)dataAll);
            byte[] sendData = MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
            try {
                Files.write(Paths.get(path, new String[0]), sendData, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(Closeable ... closeables) {
        if (closeables != null) {
            try {
                for (Closeable closeable : closeables) {
                    if (closeable == null) continue;
                    closeable.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void init() {
        try {
            UIManager.setLookAndFeel("freeseawind.lf.LittleLuckLookAndFeel");
        }
        catch (Exception e) {
            log.error((Object)("UIManager Exception:" + String.valueOf(e)));
        }
        Font myFont = new Font("Dialog", 0, 15);
        PublicUtil.initGlobalFontSetting(myFont);
    }

    public static void initGlobalFontSetting(Font font) {
        FontUIResource fontRes = new FontUIResource(font);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!key.toString().contains(".font")) continue;
            UIManager.put(key, fontRes);
        }
    }
}

